/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFailedProcCleanup {
    private static final Log LOG = LogFactory.getLog(TestFailedProcCleanup.class);
    protected static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static final TableName TABLE;
    private static final byte[] FAMILY;
    private static final int evictionDelay = 10000;

    @BeforeClass
    public static void setUpBeforeClass() {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.procedure.cleaner.evict.ttl", 10000);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.cleanupTestDir();
        TEST_UTIL.cleanupDataTestDirOnTestFS();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFailCreateTable() throws Exception {
        conf.set("hbase.coprocessor.master.classes", CreateFailObserver.class.getName());
        TEST_UTIL.startMiniCluster(3);
        try {
            TEST_UTIL.createTable(TABLE, FAMILY);
        }
        catch (AccessDeniedException e) {
            LOG.debug((Object)"Ignoring exception: ", (Throwable)e);
            Thread.sleep(30000L);
        }
        List procedureInfos = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().listProcedures();
        for (ProcedureInfo procedureInfo : procedureInfos) {
            if (!procedureInfo.getProcName().equals("CreateTableProcedure") || procedureInfo.getProcState() != ProcedureProtos.ProcedureState.ROLLEDBACK) continue;
            Assert.fail((String)("Found procedure " + procedureInfo + " that hasn't been cleaned up"));
        }
    }

    @Test
    public void testFailCreateTableHandler() throws Exception {
        conf.set("hbase.coprocessor.master.classes", CreateFailObserverHandler.class.getName());
        TEST_UTIL.startMiniCluster(3);
        try {
            TEST_UTIL.createTable(TABLE, FAMILY);
        }
        catch (AccessDeniedException e) {
            LOG.debug((Object)"Ignoring exception: ", (Throwable)e);
            Thread.sleep(30000L);
        }
        List procedureInfos = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().listProcedures();
        for (ProcedureInfo procedureInfo : procedureInfos) {
            if (!procedureInfo.getProcName().equals("CreateTableProcedure") || procedureInfo.getProcState() != ProcedureProtos.ProcedureState.ROLLEDBACK) continue;
            Assert.fail((String)("Found procedure " + procedureInfo + " that hasn't been cleaned up"));
        }
    }

    static {
        TABLE = TableName.valueOf((String)"test");
        FAMILY = Bytes.toBytesBinary((String)"f");
    }

    public static class CreateFailObserverHandler
    extends BaseMasterObserver {
        public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (desc.getTableName().equals((Object)TABLE)) {
                throw new AccessDeniedException("Don't allow creation of table");
            }
        }
    }

    public static class CreateFailObserver
    extends BaseMasterObserver {
        public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (desc.getTableName().equals((Object)TABLE)) {
                throw new AccessDeniedException("Don't allow creation of table");
            }
        }
    }
}

