/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCatalogJanitorInMemoryStates {
    private static final Log LOG = LogFactory.getLog(TestCatalogJanitorInMemoryStates.class);
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    @Rule
    public final TestName name = new TestName();
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testInMemoryParentCleanup() throws IOException, InterruptedException {
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        ServerManager sm = TEST_UTIL.getHBaseCluster().getMaster().getServerManager();
        CatalogJanitor janitor = TestCatalogJanitorInMemoryStates.TEST_UTIL.getHBaseCluster().getMaster().catalogJanitorChore;
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.enableCatalogJanitor(false);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTable t = TEST_UTIL.createTable(tableName, FAMILY);
        int rowCount = TEST_UTIL.loadTable((Table)t, FAMILY, false);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
        List allRegionLocations = locator.getAllRegionLocations();
        HRegionLocation parent = (HRegionLocation)allRegionLocations.get(0);
        List<HRegionLocation> daughters = this.splitRegion(parent.getRegionInfo());
        LOG.info((Object)("Parent region: " + parent));
        LOG.info((Object)("Daughter regions: " + daughters));
        Assert.assertNotNull((String)("Should have found daughter regions for " + parent), daughters);
        Assert.assertTrue((String)"Parent region should exist in RegionStates", (boolean)am.getRegionStates().isRegionInRegionStates(parent.getRegionInfo()));
        Assert.assertTrue((String)"Parent region should exist in ServerManager", (boolean)sm.isRegionInServerManagerStates(parent.getRegionInfo()));
        Result r = MetaMockingUtil.getMetaTableRowResult(parent.getRegionInfo(), null, daughters.get(0).getRegionInfo(), daughters.get(1).getRegionInfo());
        Thread.sleep(5000L);
        janitor.cleanParent(parent.getRegionInfo(), r);
        Thread.sleep(5000L);
        Assert.assertFalse((String)"Parent region should have been removed from RegionStates", (boolean)am.getRegionStates().isRegionInRegionStates(parent.getRegionInfo()));
        Assert.assertFalse((String)"Parent region should have been removed from ServerManager", (boolean)sm.isRegionInServerManagerStates(parent.getRegionInfo()));
    }

    @Test(timeout=180000L)
    public void testInMemoryForReplicaParentCleanup() throws Exception {
        final AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        CatalogJanitor janitor = TestCatalogJanitorInMemoryStates.TEST_UTIL.getHBaseCluster().getMaster().catalogJanitorChore;
        TableName tableName = TableName.valueOf((String)"testInMemoryForReplicaParentCleanup");
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor(tableName.getNameAsString());
        hdt.setRegionReplication(2);
        TEST_UTIL.createTable(hdt, (byte[][])new byte[][]{FAMILY}, TEST_UTIL.getConfiguration());
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
        List allRegionLocations = locator.getAllRegionLocations();
        Assert.assertTrue((allRegionLocations.size() == 2 ? 1 : 0) != 0);
        final HRegionLocation primaryParentRegion = RegionReplicaUtil.isDefaultReplica((int)((HRegionLocation)allRegionLocations.get(0)).getRegionInfo().getReplicaId()) ? (HRegionLocation)allRegionLocations.get(0) : (HRegionLocation)allRegionLocations.get(1);
        final HRegionLocation replicaParentRegion = RegionReplicaUtil.isDefaultReplica((int)((HRegionLocation)allRegionLocations.get(0)).getRegionInfo().getReplicaId()) ? (HRegionLocation)allRegionLocations.get(1) : (HRegionLocation)allRegionLocations.get(0);
        Assert.assertNotNull((String)("Should have found daughter regions for " + primaryParentRegion), this.splitRegion(primaryParentRegion.getRegionInfo(), Bytes.toBytes((String)"a")));
        TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !am.getRegionStates().existsInServerHoldings(primaryParentRegion.getServerName(), primaryParentRegion.getRegionInfo()) && !am.getRegionStates().existsInServerHoldings(replicaParentRegion.getServerName(), replicaParentRegion.getRegionInfo());
            }
        });
    }

    private List<HRegionLocation> splitRegion(HRegionInfo r) throws IOException, InterruptedException {
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        Connection connection = TEST_UTIL.getConnection();
        admin.splitRegion(r.getEncodedNameAsBytes());
        admin.close();
        PairOfSameType<HRegionInfo> regions = this.waitOnDaughters(r);
        if (regions != null) {
            try (RegionLocator rl = connection.getRegionLocator(r.getTable());){
                locations.add(rl.getRegionLocation(((HRegionInfo)regions.getFirst()).getEncodedNameAsBytes()));
                locations.add(rl.getRegionLocation(((HRegionInfo)regions.getSecond()).getEncodedNameAsBytes()));
            }
            return locations;
        }
        return locations;
    }

    private List<HRegionLocation> splitRegion(HRegionInfo r, byte[] splitPoint) throws IOException, InterruptedException {
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        Connection connection = TEST_UTIL.getConnection();
        admin.splitRegion(r.getEncodedNameAsBytes(), splitPoint);
        admin.close();
        PairOfSameType<HRegionInfo> regions = this.waitOnDaughters(r);
        if (regions != null) {
            try (RegionLocator rl = connection.getRegionLocator(r.getTable());){
                locations.add(rl.getRegionLocation(((HRegionInfo)regions.getFirst()).getEncodedNameAsBytes()));
                locations.add(rl.getRegionLocation(((HRegionInfo)regions.getSecond()).getEncodedNameAsBytes()));
            }
            return locations;
        }
        return locations;
    }

    private PairOfSameType<HRegionInfo> waitOnDaughters(HRegionInfo r) throws IOException {
        long start = System.currentTimeMillis();
        PairOfSameType pair = null;
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            PairOfSameType pairOfSameType;
            block15: {
                Table metaTable = conn.getTable(TableName.META_TABLE_NAME);
                try {
                    Result result = null;
                    HRegionInfo region = null;
                    while (System.currentTimeMillis() - start < 60000L && (result = metaTable.get(new Get(r.getRegionName()))) != null) {
                        region = MetaTableAccessor.getHRegionInfo((Result)result);
                        if (region.isSplitParent()) {
                            LOG.debug((Object)(region.toString() + " IS a parent!"));
                            pair = MetaTableAccessor.getDaughterRegions((Result)result);
                            break;
                        }
                        Threads.sleep((long)100L);
                    }
                    if (pair == null || pair.getFirst() == null || pair.getSecond() == null) {
                        throw new IOException("Failed to get daughters, for parent region: " + r);
                    }
                    pairOfSameType = pair;
                    if (metaTable == null) break block15;
                }
                catch (Throwable throwable) {
                    if (metaTable != null) {
                        try {
                            metaTable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                metaTable.close();
            }
            return pairOfSameType;
        }
    }
}

