/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import org.apache.hadoop.hbase.rest.model.TableInfoModel;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableInfoModel
extends TestModelBase<TableInfoModel> {
    private static final String TABLE = "testtable";
    private static final byte[] START_KEY = Bytes.toBytes((String)"abracadbra");
    private static final byte[] END_KEY = Bytes.toBytes((String)"zzyzx");
    private static final long ID = 8731042424L;
    private static final String LOCATION = "testhost:9876";

    public TestTableInfoModel() throws Exception {
        super(TableInfoModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><TableInfo name=\"testtable\"><Region endKey=\"enp5eng=\" id=\"8731042424\" location=\"testhost:9876\" name=\"testtable,abracadbra,8731042424.ad9860f031282c46ed431d7af8f94aca.\" startKey=\"YWJyYWNhZGJyYQ==\"/></TableInfo>";
        this.AS_PB = "Cgl0ZXN0dGFibGUSSQofdGVzdHRhYmxlLGFicmFjYWRicmEsODczMTA0MjQyNBIKYWJyYWNhZGJyYRoFenp5engg+MSkwyAqDXRlc3Rob3N0Ojk4NzY=";
        this.AS_JSON = "{\"name\":\"testtable\",\"Region\":[{\"endKey\":\"enp5eng=\",\"id\":8731042424,\"location\":\"testhost:9876\",\"name\":\"testtable,abracadbra,8731042424.ad9860f031282c46ed431d7af8f94aca.\",\"startKey\":\"YWJyYWNhZGJyYQ==\"}]}";
    }

    @Override
    protected TableInfoModel buildTestModel() {
        TableInfoModel model = new TableInfoModel();
        model.setName(TABLE);
        model.add(new TableRegionModel(TABLE, 8731042424L, START_KEY, END_KEY, LOCATION));
        return model;
    }

    @Override
    protected void checkModel(TableInfoModel model) {
        TestTableInfoModel.assertEquals((String)TABLE, (String)model.getName());
        Iterator regions = model.getRegions().iterator();
        TableRegionModel region = (TableRegionModel)regions.next();
        TestTableInfoModel.assertTrue((boolean)Bytes.equals((byte[])region.getStartKey(), (byte[])START_KEY));
        TestTableInfoModel.assertTrue((boolean)Bytes.equals((byte[])region.getEndKey(), (byte[])END_KEY));
        TestTableInfoModel.assertEquals((long)8731042424L, (long)region.getId());
        TestTableInfoModel.assertEquals((String)LOCATION, (String)region.getLocation());
        TestTableInfoModel.assertFalse((boolean)regions.hasNext());
    }

    @Override
    @Test
    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    @Override
    @Test
    public void testFromXML() throws Exception {
        this.checkModel((TableInfoModel)this.fromXML(this.AS_XML));
    }

    @Override
    @Test
    public void testFromPB() throws Exception {
        this.checkModel((TableInfoModel)this.fromPB(this.AS_PB));
    }
}

