/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.model.StorageClusterVersionModel;
import org.apache.hadoop.hbase.util.VersionInfo;

@InterfaceAudience.Private
public class StorageClusterVersionResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(StorageClusterVersionResource.class);
    static CacheControl cacheControl = new CacheControl();

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            StorageClusterVersionModel model = new StorageClusterVersionModel();
            ClusterStatus clusterStatus = this.servlet.getAdmin().getClusterStatus();
            String version = clusterStatus != null ? clusterStatus.getHBaseVersion() : VersionInfo.getVersion();
            model.setVersion(version);
            Response.ResponseBuilder response = Response.ok((Object)model);
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

