/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.model.StorageClusterStatusModel;

@InterfaceAudience.Private
public class StorageClusterStatusResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(StorageClusterStatusResource.class);
    static CacheControl cacheControl = new CacheControl();

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            Response.ResponseBuilder response;
            if (ConnectionFactory.isMapRDBOnlyCluster((Configuration)this.servlet.getAdmin().getConfiguration())) {
                response = Response.ok();
            } else {
                ClusterStatus status = this.servlet.getAdmin().getClusterStatus();
                StorageClusterStatusModel model = new StorageClusterStatusModel();
                model.setRegions(status.getRegionsCount());
                model.setRequests(status.getRequestsCount());
                model.setAverageLoad(status.getAverageLoad());
                for (ServerName info : status.getServers()) {
                    ServerLoad load = status.getLoad(info);
                    StorageClusterStatusModel.Node node = model.addLiveNode(info.getHostname() + ":" + Integer.toString(info.getPort()), info.getStartcode(), load.getUsedHeapMB(), load.getMaxHeapMB());
                    node.setRequests(load.getNumberOfRequests());
                    for (RegionLoad region : load.getRegionsLoad().values()) {
                        node.addRegion(region.getName(), region.getStores(), region.getStorefiles(), region.getStorefileSizeMB(), region.getMemStoreSizeMB(), region.getStorefileIndexSizeMB(), region.getReadRequestsCount(), region.getWriteRequestsCount(), region.getRootIndexSizeKB(), region.getTotalStaticIndexSizeKB(), region.getTotalStaticBloomSizeKB(), region.getTotalCompactingKVs(), region.getCurrentCompactedKVs());
                    }
                }
                for (ServerName name : status.getDeadServerNames()) {
                    model.addDeadNode(name.toString());
                }
                response = Response.ok((Object)model);
            }
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

