/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.NamespacesResource;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.StorageClusterStatusResource;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.VersionResource;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableModel;

@Path(value="/")
@InterfaceAudience.Private
public class RootResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(RootResource.class);
    static CacheControl cacheControl = new CacheControl();

    private final TableListModel getTableList() throws IOException {
        TableName[] tableNames;
        TableListModel tableList = new TableListModel();
        for (TableName name : tableNames = this.servlet.getAdmin().listTableNames()) {
            tableList.add(new TableModel(name.getNameAsString()));
        }
        return tableList;
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            Response.ResponseBuilder response = Response.ok((Object)this.getTableList());
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return this.processException(e);
        }
    }

    @Path(value="status/cluster")
    public StorageClusterStatusResource getClusterStatusResource() throws IOException {
        return new StorageClusterStatusResource();
    }

    @Path(value="version")
    public VersionResource getVersionResource() throws IOException {
        return new VersionResource();
    }

    @Path(value="{table}")
    public TableResource getTableResource(@PathParam(value="table") String table) throws IOException {
        return new TableResource(table);
    }

    @Path(value="namespaces")
    public NamespacesResource getNamespaceResource() throws IOException {
        return new NamespacesResource();
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

