/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestColumnSchemaModel
extends TestModelBase<ColumnSchemaModel> {
    protected static final String COLUMN_NAME = "testcolumn";
    protected static final boolean BLOCKCACHE = true;
    protected static final int BLOCKSIZE = 16384;
    protected static final String BLOOMFILTER = "NONE";
    protected static final String COMPRESSION = "GZ";
    protected static final boolean IN_MEMORY = false;
    protected static final int TTL = 86400;
    protected static final int VERSIONS = 1;

    public TestColumnSchemaModel() throws Exception {
        super(ColumnSchemaModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ColumnSchema name=\"testcolumn\" BLOCKSIZE=\"16384\" BLOOMFILTER=\"NONE\" BLOCKCACHE=\"true\" COMPRESSION=\"GZ\" VERSIONS=\"1\" TTL=\"86400\" IN_MEMORY=\"false\"/>";
        this.AS_JSON = "{\"name\":\"testcolumn\",\"BLOCKSIZE\":\"16384\",\"BLOOMFILTER\":\"NONE\",\"BLOCKCACHE\":\"true\",\"COMPRESSION\":\"GZ\",\"VERSIONS\":\"1\",\"TTL\":\"86400\",\"IN_MEMORY\":\"false\"}";
    }

    @Override
    protected ColumnSchemaModel buildTestModel() {
        ColumnSchemaModel model = new ColumnSchemaModel();
        model.setName(COLUMN_NAME);
        model.__setBlocksize(16384);
        model.__setBloomfilter(BLOOMFILTER);
        model.__setBlockcache(true);
        model.__setCompression(COMPRESSION);
        model.__setVersions(1);
        model.__setTTL(86400);
        model.__setInMemory(false);
        return model;
    }

    @Override
    protected void checkModel(ColumnSchemaModel model) {
        TestColumnSchemaModel.assertEquals((String)COLUMN_NAME, (String)model.getName());
        TestColumnSchemaModel.assertEquals((boolean)true, (boolean)model.__getBlockcache());
        TestColumnSchemaModel.assertEquals((int)16384, (int)model.__getBlocksize());
        TestColumnSchemaModel.assertEquals((String)BLOOMFILTER, (String)model.__getBloomfilter());
        TestColumnSchemaModel.assertTrue((boolean)model.__getCompression().equalsIgnoreCase(COMPRESSION));
        TestColumnSchemaModel.assertEquals((boolean)false, (boolean)model.__getInMemory());
        TestColumnSchemaModel.assertEquals((int)86400, (int)model.__getTTL());
        TestColumnSchemaModel.assertEquals((int)1, (int)model.__getVersions());
    }

    @Override
    public void testFromPB() throws Exception {
    }
}

