/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.TableInfoModel;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableModel;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestTableResource {
    private static final Log LOG = LogFactory.getLog(TestTableResource.class);
    private static final TableName TABLE = TableName.valueOf((String)"TestTableResource");
    private static final String COLUMN_FAMILY = "test";
    private static final String COLUMN = "test:qualifier";
    private static final int NUM_REGIONS = 4;
    private static List<HRegionLocation> regionMap;
    private static final HBaseTestingUtility TEST_UTIL;
    private static final HBaseRESTTestingUtility REST_TEST_UTIL;
    private static Client client;
    private static JAXBContext context;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        context = JAXBContext.newInstance((Class[])new Class[]{TableModel.class, TableInfoModel.class, TableListModel.class, TableRegionModel.class});
        TEST_UTIL.createMultiRegionTable(TABLE, Bytes.toBytes((String)COLUMN_FAMILY), 4);
        byte[] k = new byte[3];
        byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.toBytes((String)COLUMN));
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int b1 = 97; b1 < 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 < 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 < 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.setDurability(Durability.SKIP_WAL);
                    put.add(famAndQf[0], famAndQf[1], k);
                    puts.add(put);
                }
            }
        }
        Connection connection = TEST_UTIL.getConnection();
        Table table = connection.getTable(TABLE);
        table.put(puts);
        table.close();
        RegionLocator regionLocator = connection.getRegionLocator(TABLE);
        List m = regionLocator.getAllRegionLocations();
        Assert.assertEquals((long)4L, (long)m.size());
        regionMap = m;
        LOG.error((Object)("regions: " + regionMap));
        regionLocator.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void checkTableList(TableListModel model) {
        boolean found = false;
        Iterator tables = model.getTables().iterator();
        Assert.assertTrue((boolean)tables.hasNext());
        while (tables.hasNext()) {
            TableModel table = (TableModel)tables.next();
            if (!table.getName().equals(TABLE.getNameAsString())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    void checkTableInfo(TableInfoModel model) {
        Assert.assertEquals((Object)model.getName(), (Object)TABLE.getNameAsString());
        Iterator regions = model.getRegions().iterator();
        Assert.assertTrue((boolean)regions.hasNext());
        while (regions.hasNext()) {
            TableRegionModel region = (TableRegionModel)regions.next();
            boolean found = false;
            LOG.debug((Object)("looking for region " + region.getName()));
            for (HRegionLocation e : regionMap) {
                HRegionInfo hri = e.getRegionInfo();
                String hriRegionName = Bytes.toString((byte[])hri.getRegionName());
                String regionName = region.getName();
                LOG.debug((Object)("comparing to region " + hriRegionName));
                if (!hriRegionName.equals(regionName)) continue;
                found = true;
                byte[] startKey = hri.getStartKey();
                byte[] endKey = hri.getEndKey();
                ServerName serverName = e.getServerName();
                InetSocketAddress sa = new InetSocketAddress(serverName.getHostname(), serverName.getPort());
                String location = sa.getHostName() + ":" + Integer.valueOf(sa.getPort());
                Assert.assertEquals((long)hri.getRegionId(), (long)region.getId());
                Assert.assertTrue((boolean)Bytes.equals((byte[])startKey, (byte[])region.getStartKey()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])endKey, (byte[])region.getEndKey()));
                Assert.assertEquals((Object)location, (Object)region.getLocation());
                break;
            }
            Assert.assertTrue((String)("Couldn't find region " + region.getName()), (boolean)found);
        }
    }

    @Test
    public void testTableListText() throws IOException {
        Response response = client.get("/", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/plain", (Object)response.getHeader("content-type"));
    }

    @Test
    public void testTableListXML() throws IOException, JAXBException {
        Response response = client.get("/", "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        TableListModel model = (TableListModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        TestTableResource.checkTableList(model);
    }

    @Test
    public void testTableListJSON() throws IOException {
        Response response = client.get("/", "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
    }

    @Test
    public void testTableListPB() throws IOException, JAXBException {
        Response response = client.get("/", "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        TableListModel model = new TableListModel();
        model.getObjectFromMessage(response.getBody());
        TestTableResource.checkTableList(model);
        response = client.get("/", "application/protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/protobuf", (Object)response.getHeader("content-type"));
        model = new TableListModel();
        model.getObjectFromMessage(response.getBody());
        TestTableResource.checkTableList(model);
    }

    @Test
    public void testTableInfoText() throws IOException {
        Response response = client.get("/" + TABLE + "/regions", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/plain", (Object)response.getHeader("content-type"));
    }

    @Test
    public void testTableInfoXML() throws IOException, JAXBException {
        Response response = client.get("/" + TABLE + "/regions", "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        TableInfoModel model = (TableInfoModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        this.checkTableInfo(model);
    }

    @Test
    public void testTableInfoJSON() throws IOException {
        Response response = client.get("/" + TABLE + "/regions", "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
    }

    @Test
    public void testTableInfoPB() throws IOException, JAXBException {
        Response response = client.get("/" + TABLE + "/regions", "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        TableInfoModel model = new TableInfoModel();
        model.getObjectFromMessage(response.getBody());
        this.checkTableInfo(model);
        response = client.get("/" + TABLE + "/regions", "application/protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/protobuf", (Object)response.getHeader("content-type"));
        model = new TableInfoModel();
        model.getObjectFromMessage(response.getBody());
        this.checkTableInfo(model);
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        REST_TEST_UTIL = new HBaseRESTTestingUtility();
    }
}

