/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestGzipFilter {
    private static final TableName TABLE = TableName.valueOf((String)"TestGzipFilter");
    private static final String CFA = "a";
    private static final String COLUMN_1 = "a:1";
    private static final String COLUMN_2 = "a:2";
    private static final String ROW_1 = "testrow1";
    private static final byte[] VALUE_1 = Bytes.toBytes((String)"testvalue1");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(TABLE)) {
            return;
        }
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        htd.addFamily(new HColumnDescriptor(CFA));
        admin.createTable(htd);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGzipFilter() throws Exception {
        String path = "/" + TABLE + "/testrow1/a:1";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(bos);
        os.write(VALUE_1);
        os.close();
        byte[] value_1_gzip = bos.toByteArray();
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/octet-stream"), new BasicHeader("Content-Encoding", "gzip")};
        Response response = client.put(path, headers, value_1_gzip);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Table table = TEST_UTIL.getConnection().getTable(TABLE);
        Get get = new Get(Bytes.toBytes((String)ROW_1));
        get.addColumn(Bytes.toBytes((String)CFA), Bytes.toBytes((String)"1"));
        Result result = table.get(get);
        byte[] value = result.getValue(Bytes.toBytes((String)CFA), Bytes.toBytes((String)"1"));
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])VALUE_1));
        headers[0] = new BasicHeader("Accept", "application/octet-stream");
        headers[1] = new BasicHeader("Accept-Encoding", "gzip");
        response = client.get(path, headers);
        Assert.assertEquals((long)200L, (long)response.getCode());
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBody());
        GZIPInputStream is = new GZIPInputStream(bis);
        value = new byte[VALUE_1.length];
        is.read(value, 0, VALUE_1.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])VALUE_1));
        is.close();
        table.close();
        this.testScannerResultCodes();
    }

    void testScannerResultCodes() throws Exception {
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "text/xml"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "gzip")};
        Response response = client.post("/" + TABLE + "/scanner", headers, Bytes.toBytes((String)"<Scanner/>"));
        Assert.assertEquals((long)201L, (long)response.getCode());
        String scannerUrl = response.getLocation();
        Assert.assertNotNull((Object)scannerUrl);
        response = client.get(scannerUrl);
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = client.get(scannerUrl);
        Assert.assertEquals((long)204L, (long)response.getCode());
    }
}

