/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.rest.RESTServer;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRESTTestingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRESTTestingUtility.class);
    private RESTServer server;

    public int getServletPort() {
        return this.server.getPort();
    }

    public void startServletContainer(Configuration conf) throws Exception {
        if (this.server != null) {
            LOG.error("RESTServer already running");
            return;
        }
        conf.setInt("hbase.rest.port", 0);
        conf.setInt("hbase.rest.info.port", -1);
        conf.setBoolean("hbase.rest.skip.login", true);
        this.server = new RESTServer(conf);
        this.server.run();
        LOG.info("started " + this.server.getClass().getName() + " on port " + this.server.getPort());
    }

    public void shutdownServletContainer() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
                RESTServlet.stop();
            }
            catch (Exception e) {
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
        }
    }
}

