/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALProcedureStore {
    private static final Log LOG = LogFactory.getLog(TestWALProcedureStore.class);
    private static final int PROCEDURE_STORE_SLOTS = 1;
    private static final Procedure NULL_PROC = null;
    private WALProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.fs, this.logDir);
        this.procStore.start(1);
        this.procStore.recoverLease();
        this.procStore.load((ProcedureStore.ProcedureLoader)new ProcedureTestingUtility.LoadCounter());
    }

    @After
    public void tearDown() throws IOException {
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    private void storeRestart(ProcedureStore.ProcedureLoader loader) throws Exception {
        ProcedureTestingUtility.storeRestart((ProcedureStore)this.procStore, loader);
    }

    @Test
    public void testEmptyRoll() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.procStore.periodicRollForTesting();
        }
        FileStatus[] status = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)status.length);
    }

    @Test
    public void testEmptyLogLoad() throws Exception {
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)0L, (long)loader.getMaxProcId());
        Assert.assertEquals((long)0L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testLoad() throws Exception {
        HashSet<Long> procIds = new HashSet<Long>();
        TestSequentialProcedure proc1 = new TestSequentialProcedure();
        procIds.add(proc1.getProcId());
        this.procStore.insert((Procedure)proc1, null);
        TestSequentialProcedure proc2 = new TestSequentialProcedure();
        Procedure[] child2 = new Procedure[]{new TestSequentialProcedure(), new TestSequentialProcedure()};
        procIds.add(proc2.getProcId());
        procIds.add(child2[0].getProcId());
        procIds.add(child2[1].getProcId());
        this.procStore.insert((Procedure)proc2, child2);
        this.verifyProcIdsOnRestart(procIds);
        this.procStore.update((Procedure)proc1);
        this.procStore.update(child2[1]);
        this.procStore.delete(child2[1].getProcId());
        procIds.remove(child2[1].getProcId());
        this.verifyProcIdsOnRestart(procIds);
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)3L, (long)logs.length);
        for (int i = 0; i < logs.length; ++i) {
            this.corruptLog(logs[i], 4L);
        }
        this.verifyProcIdsOnRestart(procIds);
    }

    @Test
    public void testNoTrailerDoubleRestart() throws Exception {
        TestSequentialProcedure proc0 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc0, null);
        TestSequentialProcedure proc1 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc1, null);
        TestSequentialProcedure proc2 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc2, null);
        this.procStore.rollWriterForTesting();
        this.procStore.delete(proc1.getProcId());
        this.procStore.rollWriterForTesting();
        this.procStore.update((Procedure)proc2);
        this.procStore.rollWriterForTesting();
        this.procStore.delete(proc2.getProcId());
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)4L, (long)logs.length);
        for (int i = 0; i < logs.length; ++i) {
            this.corruptLog(logs[i], 4L);
        }
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)1L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
        Assert.assertEquals((long)5L, (long)this.fs.listStatus(this.logDir).length);
        loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)1L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
        this.procStore.delete(proc0.getProcId());
        this.procStore.periodicRollForTesting();
        Assert.assertEquals((long)1L, (long)this.fs.listStatus(this.logDir).length);
        this.storeRestart(loader);
    }

    @Test
    public void testCorruptedTrailer() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.procStore.insert((Procedure)new TestSequentialProcedure(), null);
        }
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)logs.length);
        this.corruptLog(logs[0], 4L);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)100L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testCorruptedEntries() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.procStore.insert((Procedure)new TestSequentialProcedure(), null);
        }
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)logs.length);
        this.corruptLog(logs[0], 1823L);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertTrue((this.procStore.getCorruptedLogs() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.procStore.getCorruptedLogs().size());
        Assert.assertEquals((long)85L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testCorruptedProcedures() throws Exception {
        int i;
        ProcedureTestingUtility.TestProcedure[] rootProcs = new ProcedureTestingUtility.TestProcedure[10];
        for (i = 1; i <= rootProcs.length; ++i) {
            rootProcs[i - 1] = new ProcedureTestingUtility.TestProcedure(i, 0L);
            this.procStore.insert((Procedure)rootProcs[i - 1], null);
            rootProcs[i - 1].addStackId(0);
            this.procStore.update((Procedure)rootProcs[i - 1]);
        }
        this.procStore.rollWriterForTesting();
        for (i = 1; i <= rootProcs.length; ++i) {
            ProcedureTestingUtility.TestProcedure b = new ProcedureTestingUtility.TestProcedure(rootProcs.length + i, i);
            rootProcs[i - 1].addStackId(1);
            this.procStore.insert((Procedure)rootProcs[i - 1], new Procedure[]{b});
        }
        this.procStore.rollWriterForTesting();
        for (i = 1; i <= rootProcs.length; ++i) {
            this.procStore.update((Procedure)new ProcedureTestingUtility.TestProcedure(rootProcs.length + i, i));
        }
        this.procStore.stop(false);
        Object[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((String)Arrays.toString(logs), (long)2L, (long)logs.length);
        Arrays.sort(logs, new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus o1, FileStatus o2) {
                return o1.getPath().getName().compareTo(o2.getPath().getName());
            }
        });
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)(rootProcs.length * 2), (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
        this.fs.delete(logs[0].getPath(), false);
        loader.reset();
        this.storeRestart(loader);
        Assert.assertEquals((long)0L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)rootProcs.length, (long)loader.getCorruptedCount());
        for (Procedure proc : loader.getCorrupted()) {
            Assert.assertTrue((String)proc.toString(), (proc.getParentProcId() <= (long)rootProcs.length ? 1 : 0) != 0);
            Assert.assertTrue((String)proc.toString(), (proc.getProcId() > (long)rootProcs.length && proc.getProcId() <= (long)(rootProcs.length * 2) ? 1 : 0) != 0);
        }
    }

    @Test(timeout=60000L)
    public void testWalReplayOrder_AB_A() throws Exception {
        ProcedureTestingUtility.TestProcedure a = new ProcedureTestingUtility.TestProcedure(1L, 0L);
        ProcedureTestingUtility.TestProcedure b = new ProcedureTestingUtility.TestProcedure(2L, 1L);
        this.procStore.insert((Procedure)a, null);
        a.addStackId(0);
        this.procStore.update((Procedure)a);
        this.procStore.insert((Procedure)a, new Procedure[]{b});
        b.addStackId(1);
        this.procStore.update((Procedure)b);
        this.procStore.rollWriterForTesting();
        a.addStackId(2);
        this.procStore.update((Procedure)a);
        this.storeRestart(new ProcedureStore.ProcedureLoader(){

            public void setMaxProcId(long maxProcId) {
                Assert.assertEquals((long)2L, (long)maxProcId);
            }

            public void load(ProcedureStore.ProcedureIterator procIter) throws IOException {
                Assert.assertTrue((boolean)procIter.hasNext());
                Assert.assertEquals((long)1L, (long)procIter.nextAsProcedureInfo().getProcId());
                Assert.assertTrue((boolean)procIter.hasNext());
                Assert.assertEquals((long)2L, (long)procIter.nextAsProcedureInfo().getProcId());
                Assert.assertFalse((boolean)procIter.hasNext());
            }

            public void handleCorrupted(ProcedureStore.ProcedureIterator procIter) throws IOException {
                Assert.assertFalse((boolean)procIter.hasNext());
            }
        });
    }

    @Test(timeout=60000L)
    public void testWalReplayOrder_ABC_BAD() throws Exception {
        ProcedureTestingUtility.TestProcedure a = new ProcedureTestingUtility.TestProcedure(1L, 0L);
        ProcedureTestingUtility.TestProcedure b = new ProcedureTestingUtility.TestProcedure(2L, 1L);
        ProcedureTestingUtility.TestProcedure c = new ProcedureTestingUtility.TestProcedure(3L, 2L);
        ProcedureTestingUtility.TestProcedure d = new ProcedureTestingUtility.TestProcedure(4L, 0L);
        this.procStore.insert((Procedure)a, null);
        a.addStackId(0);
        this.procStore.update((Procedure)a);
        this.procStore.insert((Procedure)a, new Procedure[]{b});
        b.addStackId(1);
        this.procStore.update((Procedure)b);
        this.procStore.insert((Procedure)b, new Procedure[]{c});
        b.addStackId(2);
        this.procStore.update((Procedure)b);
        this.procStore.rollWriterForTesting();
        b.addStackId(3);
        this.procStore.update((Procedure)b);
        a.addStackId(4);
        this.procStore.update((Procedure)a);
        this.procStore.insert((Procedure)d, null);
        d.addStackId(0);
        this.procStore.update((Procedure)d);
        this.storeRestart(new ProcedureStore.ProcedureLoader(){

            public void setMaxProcId(long maxProcId) {
                Assert.assertEquals((long)4L, (long)maxProcId);
            }

            public void load(ProcedureStore.ProcedureIterator procIter) throws IOException {
                Assert.assertTrue((boolean)procIter.hasNext());
                Assert.assertEquals((long)4L, (long)procIter.nextAsProcedureInfo().getProcId());
                Assert.assertTrue((boolean)procIter.hasNext());
                Assert.assertEquals((long)1L, (long)procIter.nextAsProcedureInfo().getProcId());
                Assert.assertTrue((boolean)procIter.hasNext());
                Assert.assertEquals((long)2L, (long)procIter.nextAsProcedureInfo().getProcId());
                Assert.assertTrue((boolean)procIter.hasNext());
                Assert.assertEquals((long)3L, (long)procIter.nextAsProcedureInfo().getProcId());
                Assert.assertFalse((boolean)procIter.hasNext());
            }

            public void handleCorrupted(ProcedureStore.ProcedureIterator procIter) throws IOException {
                Assert.assertFalse((boolean)procIter.hasNext());
            }
        });
    }

    @Test
    public void testRollAndRemove() throws IOException {
        TestSequentialProcedure proc1 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc1, null);
        TestSequentialProcedure proc2 = new TestSequentialProcedure();
        this.procStore.insert((Procedure)proc2, null);
        this.procStore.rollWriterForTesting();
        Assert.assertEquals((long)2L, (long)this.procStore.getActiveLogs().size());
        this.procStore.update((Procedure)proc1);
        this.procStore.update((Procedure)proc2);
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
        this.procStore.rollWriterForTesting();
        Assert.assertEquals((long)2L, (long)this.procStore.getActiveLogs().size());
        this.procStore.delete(proc1.getProcId());
        this.procStore.delete(proc2.getProcId());
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
    }

    @Test
    public void testFileNotFoundDuringLeaseRecovery() throws IOException {
        int i;
        ProcedureTestingUtility.TestProcedure[] procs = new ProcedureTestingUtility.TestProcedure[3];
        for (i = 0; i < procs.length; ++i) {
            procs[i] = new ProcedureTestingUtility.TestProcedure(i + 1, 0L);
            this.procStore.insert((Procedure)procs[i], null);
        }
        this.procStore.rollWriterForTesting();
        for (i = 0; i < procs.length; ++i) {
            this.procStore.update((Procedure)procs[i]);
            this.procStore.rollWriterForTesting();
        }
        this.procStore.stop(false);
        FileStatus[] status = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)(procs.length + 2), (long)status.length);
        this.procStore = new WALProcedureStore(this.htu.getConfiguration(), this.fs, this.logDir, new WALProcedureStore.LeaseRecovery(){
            private int count = 0;

            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
                if (++this.count <= 2) {
                    fs.delete(path, false);
                    LOG.debug((Object)("Simulate FileNotFound at count=" + this.count + " for " + path));
                    throw new FileNotFoundException("test file not found " + path);
                }
                LOG.debug((Object)("Simulate recoverFileLease() at count=" + this.count + " for " + path));
            }
        });
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.procStore.start(1);
        this.procStore.recoverLease();
        this.procStore.load((ProcedureStore.ProcedureLoader)loader);
        Assert.assertEquals((long)procs.length, (long)loader.getMaxProcId());
        Assert.assertEquals((long)(procs.length - 1), (long)loader.getRunnableCount());
        Assert.assertEquals((long)0L, (long)loader.getCompletedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testLoadChildren() throws Exception {
        ProcedureTestingUtility.TestProcedure a = new ProcedureTestingUtility.TestProcedure(1L, 0L);
        ProcedureTestingUtility.TestProcedure b = new ProcedureTestingUtility.TestProcedure(2L, 1L);
        ProcedureTestingUtility.TestProcedure c = new ProcedureTestingUtility.TestProcedure(3L, 1L);
        this.procStore.insert((Procedure)a, null);
        a.addStackId(0);
        this.procStore.update((Procedure)a);
        a.addStackId(1);
        this.procStore.insert((Procedure)a, new Procedure[]{b, c});
        b.addStackId(2);
        this.procStore.update((Procedure)b);
        c.addStackId(3);
        this.procStore.update((Procedure)c);
        b.addStackId(4);
        this.procStore.update((Procedure)b);
        a.addStackId(5);
        a.setFinishedState();
        this.procStore.delete((Procedure)a, new long[]{b.getProcId(), c.getProcId()});
        this.restartAndAssert(3L, 0L, 1, 0);
    }

    private void restartAndAssert(long maxProcId, long runnableCount, int completedCount, int corruptedCount) throws Exception {
        ProcedureTestingUtility.storeRestartAndAssert((ProcedureStore)this.procStore, maxProcId, runnableCount, completedCount, corruptedCount);
    }

    private void corruptLog(FileStatus logFile, long dropBytes) throws IOException {
        Assert.assertTrue((logFile.getLen() > dropBytes ? 1 : 0) != 0);
        LOG.debug((Object)("corrupt log " + logFile.getPath() + " size=" + logFile.getLen() + " drop=" + dropBytes));
        Path tmpPath = new Path(this.testDir, "corrupted.log");
        FSDataInputStream in = this.fs.open(logFile.getPath());
        FSDataOutputStream out = this.fs.create(tmpPath);
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (long)(logFile.getLen() - dropBytes), (boolean)true);
        if (!this.fs.rename(tmpPath, logFile.getPath())) {
            throw new IOException("Unable to rename");
        }
    }

    private void verifyProcIdsOnRestart(Set<Long> procIds) throws Exception {
        LOG.debug((Object)("expected: " + procIds));
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.storeRestart(loader);
        Assert.assertEquals((long)procIds.size(), (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    private void assertEmptyLogDir() {
        try {
            FileStatus[] status = this.fs.listStatus(this.logDir);
            Assert.assertTrue((String)"expected empty state-log dir", (status == null || status.length == 0 ? 1 : 0) != 0);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("expected the state-log dir to be present: " + this.logDir));
        }
        catch (IOException e) {
            Assert.fail((String)("got en exception on state-log dir list: " + e.getMessage()));
        }
    }

    public static class TestSequentialProcedure
    extends SequentialProcedure<Void> {
        private static long seqid = 0L;

        public TestSequentialProcedure() {
            this.setProcId(++seqid);
        }

        protected Procedure[] execute(Void env) {
            return null;
        }

        protected void rollback(Void env) {
        }

        protected boolean abort(Void env) {
            return false;
        }

        protected void serializeStateData(OutputStream stream) throws IOException {
            long procId = this.getProcId();
            if (procId % 2L == 0L) {
                stream.write(Bytes.toBytes((long)procId));
            }
        }

        protected void deserializeStateData(InputStream stream) throws IOException {
            long procId = this.getProcId();
            if (procId % 2L == 0L) {
                byte[] bProcId = new byte[8];
                Assert.assertEquals((long)8L, (long)stream.read(bProcId));
                Assert.assertEquals((long)procId, (long)Bytes.toLong((byte[])bProcId));
            } else {
                Assert.assertEquals((long)0L, (long)stream.available());
            }
        }
    }
}

