/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestProcedureReplayOrder {
    private static final Log LOG = LogFactory.getLog(TestProcedureReplayOrder.class);
    private static final int NUM_THREADS = 16;
    private ProcedureExecutor<Void> procExecutor;
    private TestProcedureEnv procEnv;
    private ProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.htu.getConfiguration().setInt("hbase.procedure.store.wal.sync.wait.msec", 25);
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procEnv = new TestProcedureEnv();
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.fs, this.logDir);
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)this.procEnv, this.procStore);
        this.procStore.start(16);
        this.procExecutor.start(1, true);
    }

    @After
    public void tearDown() throws IOException {
        this.procExecutor.stop();
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test(timeout=90000L)
    public void testSingleStepReplayOrder() throws Exception {
        int NUM_PROC_XTHREAD = 32;
        int NUM_PROCS = 512;
        this.submitProcedures(16, 32, TestSingleStepProcedure.class);
        while (this.procEnv.getExecId() < 512L) {
            Thread.sleep(100L);
        }
        ProcedureTestingUtility.restart(this.procExecutor);
        ProcedureTestingUtility.waitNoProcedureRunning(this.procExecutor);
        this.procEnv.assertSortedExecList(512);
    }

    @Test(timeout=90000L)
    public void testMultiStepReplayOrder() throws Exception {
        int NUM_PROC_XTHREAD = 24;
        int NUM_PROCS = 768;
        this.submitProcedures(16, 24, TestTwoStepProcedure.class);
        while (this.procEnv.getExecId() < 768L) {
            Thread.sleep(100L);
        }
        ProcedureTestingUtility.restart(this.procExecutor);
        ProcedureTestingUtility.waitNoProcedureRunning(this.procExecutor);
        this.procEnv.assertSortedExecList(768);
    }

    private void submitProcedures(int nthreads, final int nprocPerThread, final Class<?> procClazz) throws Exception {
        int i;
        Thread[] submitThreads = new Thread[nthreads];
        for (i = 0; i < submitThreads.length; ++i) {
            submitThreads[i] = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < nprocPerThread; ++i) {
                        try {
                            TestProcedureReplayOrder.this.procExecutor.submitProcedure((Procedure)procClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                            continue;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"unable to instantiate the procedure", (Throwable)e);
                            Assert.fail((String)("failure during the proc.newInstance(): " + e.getMessage()));
                        }
                    }
                }
            };
        }
        for (i = 0; i < submitThreads.length; ++i) {
            submitThreads[i].start();
        }
        for (i = 0; i < submitThreads.length; ++i) {
            submitThreads[i].join();
        }
    }

    public static class TestTwoStepProcedure
    extends TestProcedure {
        protected Procedure[] execute(TestProcedureEnv env) throws ProcedureYieldException {
            LOG.trace((Object)("execute procedure step=" + this.step + ": " + this));
            if (this.step == 0) {
                this.step = 1;
                this.execId = env.nextExecId();
                return new Procedure[]{new TestSingleStepProcedure()};
            }
            if (this.step == 2) {
                env.addToExecList(this);
                return null;
            }
            throw new ProcedureYieldException();
        }

        public String toString() {
            return "TwoStep(procId=" + this.getProcId() + " execId=" + this.execId + ")";
        }
    }

    public static class TestSingleStepProcedure
    extends TestProcedure {
        protected Procedure[] execute(TestProcedureEnv env) throws ProcedureYieldException {
            LOG.trace((Object)("execute procedure step=" + this.step + ": " + this));
            if (this.step == 0) {
                this.step = 1;
                this.execId = env.nextExecId();
                return new Procedure[]{this};
            }
            if (this.step == 2) {
                env.addToExecList(this);
                return null;
            }
            throw new ProcedureYieldException();
        }

        public String toString() {
            return "SingleStep(procId=" + this.getProcId() + " execId=" + this.execId + ")";
        }
    }

    public static abstract class TestProcedure
    extends Procedure<TestProcedureEnv> {
        protected long execId = 0L;
        protected int step = 0;

        public long getExecId() {
            return this.execId;
        }

        protected void rollback(TestProcedureEnv env) {
        }

        protected boolean abort(TestProcedureEnv env) {
            return true;
        }

        protected void serializeStateData(OutputStream stream) throws IOException {
            StreamUtils.writeLong((OutputStream)stream, (long)this.execId);
        }

        protected void deserializeStateData(InputStream stream) throws IOException {
            this.execId = StreamUtils.readLong((InputStream)stream);
            this.step = 2;
        }
    }

    private static class TestProcedureEnv {
        private ArrayList<TestProcedure> execList = new ArrayList();
        private AtomicLong execTimestamp = new AtomicLong(0L);

        private TestProcedureEnv() {
        }

        public long getExecId() {
            return this.execTimestamp.get();
        }

        public long nextExecId() {
            return this.execTimestamp.incrementAndGet();
        }

        public void addToExecList(TestProcedure proc) {
            this.execList.add(proc);
        }

        public void assertSortedExecList(int numProcs) {
            Assert.assertEquals((long)numProcs, (long)this.execList.size());
            LOG.debug((Object)("EXEC LIST: " + this.execList));
            for (int i = 0; i < this.execList.size() - 1; ++i) {
                TestProcedure a = this.execList.get(i);
                TestProcedure b = this.execList.get(i + 1);
                Assert.assertTrue((String)("exec list not sorted: " + a + " < " + b), (a.getExecId() > b.getExecId() ? 1 : 0) != 0);
            }
        }
    }
}

