/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureNonce {
    private static final Log LOG = LogFactory.getLog(TestProcedureNonce.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 2;
    private static TestProcEnv procEnv;
    private static ProcedureExecutor<TestProcEnv> procExecutor;
    private static ProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        Path testDir = this.htu.getDataTestDir();
        this.fs = testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(testDir, "proc-logs");
        procEnv = new TestProcEnv();
        procStore = ProcedureTestingUtility.createStore(this.htu.getConfiguration(), this.fs, this.logDir);
        procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)procEnv, procStore);
        TestProcedureNonce.procExecutor.testing = new ProcedureExecutor.Testing();
        procStore.start(2);
        procExecutor.start(2, true);
    }

    @After
    public void tearDown() throws IOException {
        procExecutor.stop();
        procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test(timeout=30000L)
    public void testCompletedProcWithSameNonce() throws Exception {
        long nonceGroup = 123L;
        long nonce = 2222L;
        NonceKey nonceKey = procExecutor.createNonceKey(123L, 2222L);
        Assert.assertFalse((procExecutor.registerNonce(nonceKey) >= 0L ? 1 : 0) != 0);
        TestSingleStepProcedure proc = new TestSingleStepProcedure();
        long procId = procExecutor.submitProcedure((Procedure)proc, nonceKey);
        ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        ProcedureTestingUtility.restart(procExecutor);
        ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        Assert.assertEquals((long)procId, (long)procExecutor.registerNonce(nonceKey));
        ProcedureInfo result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertProcNotFailed(result);
    }

    @Test(timeout=30000L)
    public void testRunningProcWithSameNonce() throws Exception {
        long nonceGroup = 456L;
        long nonce = 33333L;
        NonceKey nonceKey = procExecutor.createNonceKey(456L, 33333L);
        Assert.assertFalse((procExecutor.registerNonce(nonceKey) >= 0L ? 1 : 0) != 0);
        CountDownLatch latch = new CountDownLatch(1);
        TestSingleStepProcedure proc = new TestSingleStepProcedure();
        procEnv.setWaitLatch(latch);
        long procId = procExecutor.submitProcedure((Procedure)proc, nonceKey);
        while (proc.step != 1) {
            Threads.sleep((long)25L);
        }
        Assert.assertEquals((long)procId, (long)procExecutor.registerNonce(nonceKey));
        latch.countDown();
        ProcedureTestingUtility.restart(procExecutor);
        ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        Assert.assertEquals((long)procId, (long)procExecutor.registerNonce(nonceKey));
        ProcedureInfo result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertProcNotFailed(result);
    }

    @Test
    public void testSetFailureResultForNonce() throws IOException {
        long nonceGroup = 234L;
        long nonce = 55555L;
        NonceKey nonceKey = procExecutor.createNonceKey(234L, 55555L);
        Assert.assertFalse((procExecutor.registerNonce(nonceKey) >= 0L ? 1 : 0) != 0);
        procExecutor.setFailureResultForNonce(nonceKey, "testProc", User.getCurrent(), new IOException("test failure"));
        long procId = procExecutor.registerNonce(nonceKey);
        ProcedureInfo result = procExecutor.getResult(procId);
        ProcedureTestingUtility.assertProcFailed(result);
    }

    @Test(timeout=30000L)
    public void testConcurrentNonceRegistration() throws IOException {
        this.testConcurrentNonceRegistration(true, 567L, 44444L);
    }

    @Test(timeout=30000L)
    public void testConcurrentNonceRegistrationWithRollback() throws IOException {
        this.testConcurrentNonceRegistration(false, 890L, 55555L);
    }

    private void testConcurrentNonceRegistration(final boolean submitProcedure, long nonceGroup, long nonce) throws IOException {
        int i;
        final NonceKey nonceKey = procExecutor.createNonceKey(nonceGroup, nonce);
        final AtomicReference t1Exception = new AtomicReference();
        final AtomicReference t2Exception = new AtomicReference();
        final CountDownLatch t1NonceRegisteredLatch = new CountDownLatch(1);
        final CountDownLatch t2BeforeNonceRegisteredLatch = new CountDownLatch(1);
        Thread[] threads = new Thread[]{new Thread(){

            @Override
            public void run() {
                try {
                    Assert.assertFalse((String)"unexpected already registered nonce", (procExecutor.registerNonce(nonceKey) >= 0L ? 1 : 0) != 0);
                    t1NonceRegisteredLatch.countDown();
                    t2BeforeNonceRegisteredLatch.await();
                    Threads.sleep((long)1000L);
                    if (submitProcedure) {
                        CountDownLatch latch = new CountDownLatch(1);
                        TestSingleStepProcedure proc = new TestSingleStepProcedure();
                        procEnv.setWaitLatch(latch);
                        procExecutor.submitProcedure((Procedure)proc, nonceKey);
                        Threads.sleep((long)100L);
                        latch.countDown();
                    } else {
                        procExecutor.unregisterNonceIfProcedureWasNotSubmitted(nonceKey);
                    }
                }
                catch (Throwable e) {
                    t1Exception.set(e);
                }
                finally {
                    t1NonceRegisteredLatch.countDown();
                    t2BeforeNonceRegisteredLatch.countDown();
                }
            }
        }, new Thread(){

            @Override
            public void run() {
                try {
                    t1NonceRegisteredLatch.await();
                    t2BeforeNonceRegisteredLatch.countDown();
                    Assert.assertFalse((String)"unexpected non registered nonce", (procExecutor.registerNonce(nonceKey) < 0L ? 1 : 0) != 0);
                }
                catch (Throwable e) {
                    t2Exception.set(e);
                }
                finally {
                    t1NonceRegisteredLatch.countDown();
                    t2BeforeNonceRegisteredLatch.countDown();
                }
            }
        }};
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            Threads.shutdown((Thread)threads[i]);
        }
        ProcedureTestingUtility.waitNoProcedureRunning(procExecutor);
        Assert.assertEquals(null, t1Exception.get());
        Assert.assertEquals(null, t2Exception.get());
    }

    private static class TestProcEnv {
        private CountDownLatch latch = null;

        private TestProcEnv() {
        }

        public void setWaitLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public void waitOnLatch() throws InterruptedException {
            if (this.latch != null) {
                this.latch.await();
            }
        }
    }

    public static class TestSingleStepProcedure
    extends SequentialProcedure<TestProcEnv> {
        private int step = 0;

        protected Procedure[] execute(TestProcEnv env) throws InterruptedException {
            ++this.step;
            env.waitOnLatch();
            LOG.debug((Object)("execute procedure " + this + " step=" + this.step));
            ++this.step;
            this.setResult(Bytes.toBytes((int)this.step));
            return null;
        }

        protected void rollback(TestProcEnv env) {
        }

        protected boolean abort(TestProcEnv env) {
            return true;
        }
    }
}

