/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row.data;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;
import org.apache.hadoop.hbase.codec.prefixtree.encode.column.ColumnNodeWriter;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerNode;
import org.apache.hadoop.hbase.codec.prefixtree.row.BaseTestRowData;
import org.apache.hadoop.hbase.util.Bytes;

public class TestRowDataUrlsExample
extends BaseTestRowData {
    static String TENANT_ID = Integer.toString(95322);
    static String APP_ID = Integer.toString(12);
    static List<String> URLS = Lists.newArrayList((Object[])new String[]{"com.dablog/2011/10/04/boating", "com.dablog/2011/10/09/lasers", "com.jamiesrecipes", "com.jamiesrecipes/eggs"});
    static String FAMILY = "hits";
    static List<String> BROWSERS = Lists.newArrayList((Object[])new String[]{"Chrome", "IE8", "IE9beta"});
    static long TIMESTAMP = 1234567890L;
    static int MAX_VALUE = 50;
    static List<KeyValue> kvs = Lists.newArrayList();

    public static void main(String ... args) throws IOException {
        System.out.println("-- inputs --");
        System.out.println(KeyValueTestUtil.toStringWithPadding(kvs, (boolean)true));
        ByteArrayOutputStream os = new ByteArrayOutputStream(0x100000);
        PrefixTreeEncoder encoder = new PrefixTreeEncoder((OutputStream)os, false);
        for (KeyValue kv : kvs) {
            encoder.write((Cell)kv);
        }
        encoder.flush();
        System.out.println("-- qualifier SortedPtBuilderNodes --");
        for (TokenizerNode tokenizer : encoder.getQualifierWriter().getNonLeaves()) {
            System.out.println(tokenizer);
        }
        for (TokenizerNode tokenizerNode : encoder.getQualifierWriter().getLeaves()) {
            System.out.println(tokenizerNode);
        }
        System.out.println("-- qualifier PtColumnNodeWriters --");
        for (ColumnNodeWriter writer : encoder.getQualifierWriter().getColumnNodeWriters()) {
            System.out.println(writer);
        }
        System.out.println("-- rowKey SortedPtBuilderNodes --");
        for (TokenizerNode tokenizerNode : encoder.getRowWriter().getNonLeaves()) {
            System.out.println(tokenizerNode);
        }
        for (TokenizerNode tokenizerNode : encoder.getRowWriter().getLeaves()) {
            System.out.println(tokenizerNode);
        }
        System.out.println("-- row PtRowNodeWriters --");
        for (ColumnNodeWriter writer : encoder.getRowWriter().getNonLeafWriters()) {
            System.out.println(writer);
        }
        for (ColumnNodeWriter writer : encoder.getRowWriter().getLeafWriters()) {
            System.out.println(writer);
        }
        System.out.println("-- concatenated values --");
        System.out.println(Bytes.toStringBinary((byte[])encoder.getValueByteRange().deepCopyToNewArray()));
    }

    @Override
    public List<KeyValue> getInputs() {
        return kvs;
    }

    static {
        for (String rowKey : URLS) {
            for (String qualifier : BROWSERS) {
                KeyValue kv = new KeyValue(Bytes.toBytes((String)rowKey), Bytes.toBytes((String)FAMILY), Bytes.toBytes((String)qualifier), TIMESTAMP, KeyValue.Type.Put, Bytes.toBytes((String)"VvvV"));
                kvs.add(kv);
            }
        }
    }
}

