/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row.data;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.prefixtree.row.BaseTestRowData;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellScannerPosition;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class TestRowDataSearcherRowMiss
extends BaseTestRowData {
    static byte[] A = Bytes.toBytes((String)"A");
    static byte[] AA = Bytes.toBytes((String)"AA");
    static byte[] AAA = Bytes.toBytes((String)"AAA");
    static byte[] B = Bytes.toBytes((String)"B");
    static byte[] cf = Bytes.toBytes((String)"fam");
    static byte[] cq = Bytes.toBytes((String)"cq0");
    static byte[] v = Bytes.toBytes((String)"v0");
    static long ts = 55L;
    static List<KeyValue> d = Lists.newArrayList();

    @Override
    public List<KeyValue> getInputs() {
        return d;
    }

    @Override
    public void individualSearcherAssertions(CellSearcher searcher) {
        this.assertRowOffsetsCorrect();
        searcher.resetToBeforeFirstEntry();
        try {
            searcher.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Cell first = searcher.current();
        Assert.assertTrue((boolean)CellComparator.equals((Cell)((Cell)d.get(0)), (Cell)first));
        Assert.assertTrue((boolean)searcher.positionAt((Cell)d.get(1)));
        Assert.assertTrue((boolean)CellComparator.equals((Cell)((Cell)d.get(1)), (Cell)searcher.current()));
        this.testBetween1and2(searcher);
        this.testBetween2and3(searcher);
    }

    private void assertRowOffsetsCorrect() {
        Assert.assertEquals((long)4L, (long)this.getRowStartIndexes().size());
    }

    private void testBetween1and2(CellSearcher searcher) {
        KeyValue betweenAAndAAA = new KeyValue(AA, cf, cq, ts - 2L, v);
        Assert.assertFalse((boolean)searcher.positionAt((Cell)betweenAAndAAA));
        CellScannerPosition p = searcher.positionAtOrBefore((Cell)betweenAAndAAA);
        Assert.assertEquals((Object)CellScannerPosition.BEFORE, (Object)p);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)searcher.current(), (Cell)((Cell)d.get(1))));
        p = searcher.positionAtOrAfter((Cell)betweenAAndAAA);
        Assert.assertEquals((Object)CellScannerPosition.AFTER, (Object)p);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)searcher.current(), (Cell)((Cell)d.get(2))));
    }

    private void testBetween2and3(CellSearcher searcher) {
        KeyValue betweenAAAndB = new KeyValue(AAA, cf, cq, ts - 2L, v);
        Assert.assertFalse((boolean)searcher.positionAt((Cell)betweenAAAndB));
        CellScannerPosition p = searcher.positionAtOrBefore((Cell)betweenAAAndB);
        Assert.assertEquals((Object)CellScannerPosition.BEFORE, (Object)p);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)searcher.current(), (Cell)((Cell)d.get(2))));
        p = searcher.positionAtOrAfter((Cell)betweenAAAndB);
        Assert.assertEquals((Object)CellScannerPosition.AFTER, (Object)p);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)searcher.current(), (Cell)((Cell)d.get(3))));
    }

    static {
        d.add(new KeyValue(A, cf, cq, ts, v));
        d.add(new KeyValue(AA, cf, cq, ts, v));
        d.add(new KeyValue(AAA, cf, cq, ts, v));
        d.add(new KeyValue(B, cf, cq, ts, v));
    }
}

