/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row.data;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.row.BaseTestRowData;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellScannerPosition;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class TestRowDataDeeper
extends BaseTestRowData {
    static byte[] cdc = Bytes.toBytes((String)"cdc");
    static byte[] cf6 = Bytes.toBytes((String)"cf6");
    static byte[] cfc = Bytes.toBytes((String)"cfc");
    static byte[] f = Bytes.toBytes((String)"f");
    static byte[] q = Bytes.toBytes((String)"q");
    static byte[] v = Bytes.toBytes((String)"v");
    static long ts = 55L;
    static List<KeyValue> d = Lists.newArrayList();

    @Override
    public List<KeyValue> getInputs() {
        return d;
    }

    @Override
    public void individualBlockMetaAssertions(PrefixTreeBlockMeta blockMeta) {
        Assert.assertEquals((long)3L, (long)blockMeta.getRowTreeDepth());
    }

    @Override
    public void individualSearcherAssertions(CellSearcher searcher) {
        KeyValue cfcRow = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"cfc"));
        CellScannerPosition position = searcher.positionAtOrAfter((Cell)cfcRow);
        Assert.assertEquals((Object)CellScannerPosition.AFTER, (Object)position);
        Assert.assertEquals((Object)d.get(2), (Object)searcher.current());
        searcher.previous();
        Assert.assertEquals((Object)d.get(1), (Object)searcher.current());
    }

    static {
        d.add(new KeyValue(cdc, f, q, ts, v));
        d.add(new KeyValue(cf6, f, q, ts, v));
        d.add(new KeyValue(cfc, f, q, ts, v));
    }
}

