/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import org.apache.hadoop.hbase.metrics.Snapshot;
import org.apache.hadoop.hbase.metrics.impl.HistogramImpl;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHistogramImpl {
    @Test
    public void testUpdate() {
        HistogramImpl histogram = new HistogramImpl();
        Assert.assertEquals((long)0L, (long)histogram.getCount());
        histogram.update(0);
        Assert.assertEquals((long)1L, (long)histogram.getCount());
        histogram.update(10);
        Assert.assertEquals((long)2L, (long)histogram.getCount());
        histogram.update(20);
        histogram.update(30);
        Assert.assertEquals((long)4L, (long)histogram.getCount());
    }

    @Test
    public void testSnapshot() {
        int i;
        HistogramImpl histogram = new HistogramImpl();
        for (int i2 = 0; i2 < 100; ++i2) {
            histogram.update(i2);
        }
        Snapshot snapshot = histogram.snapshot();
        Assert.assertEquals((long)100L, (long)snapshot.getCount());
        Assert.assertEquals((long)49L, (long)snapshot.getMedian());
        Assert.assertEquals((long)49L, (long)snapshot.getMean());
        Assert.assertEquals((long)0L, (long)snapshot.getMin());
        Assert.assertEquals((long)99L, (long)snapshot.getMax());
        Assert.assertEquals((long)24L, (long)snapshot.get25thPercentile());
        Assert.assertEquals((long)74L, (long)snapshot.get75thPercentile());
        Assert.assertEquals((long)89L, (long)snapshot.get90thPercentile());
        Assert.assertEquals((long)94L, (long)snapshot.get95thPercentile());
        Assert.assertEquals((long)97L, (long)snapshot.get98thPercentile());
        Assert.assertEquals((long)98L, (long)snapshot.get99thPercentile());
        Assert.assertEquals((long)98L, (long)snapshot.get999thPercentile());
        Assert.assertEquals((long)100L, (long)snapshot.getCountAtOrBelow(50L));
        Assert.assertEquals((long)100L, (long)histogram.getCount());
        for (i = 100; i < 200; ++i) {
            histogram.update(i);
        }
        Assert.assertEquals((long)200L, (long)histogram.getCount());
        snapshot = histogram.snapshot();
        Assert.assertEquals((long)100L, (long)snapshot.getCount());
        Assert.assertEquals((long)150L, (long)snapshot.getMedian());
        Assert.assertEquals((long)149L, (long)snapshot.getMean());
        Assert.assertEquals((long)100L, (long)snapshot.getMin());
        Assert.assertEquals((long)199L, (long)snapshot.getMax());
        Assert.assertEquals((long)125L, (long)snapshot.get25thPercentile());
        Assert.assertEquals((long)175L, (long)snapshot.get75thPercentile());
        Assert.assertEquals((long)190L, (long)snapshot.get90thPercentile());
        Assert.assertEquals((long)195L, (long)snapshot.get95thPercentile());
        Assert.assertEquals((long)198L, (long)snapshot.get98thPercentile());
        Assert.assertEquals((long)199L, (long)snapshot.get99thPercentile());
        Assert.assertEquals((long)199L, (long)snapshot.get999thPercentile());
        for (i = 500; i < 1000; ++i) {
            histogram.update(i);
        }
        snapshot = histogram.snapshot();
        Assert.assertEquals((long)500L, (long)snapshot.getCount());
        Assert.assertEquals((long)749L, (long)snapshot.getMedian());
        Assert.assertEquals((long)749L, (long)snapshot.getMean());
        Assert.assertEquals((long)500L, (long)snapshot.getMin());
        Assert.assertEquals((long)999L, (long)snapshot.getMax());
        Assert.assertEquals((long)624L, (long)snapshot.get25thPercentile());
        Assert.assertEquals((long)874L, (long)snapshot.get75thPercentile());
        Assert.assertEquals((long)949L, (long)snapshot.get90thPercentile());
        Assert.assertEquals((long)974L, (long)snapshot.get95thPercentile());
        Assert.assertEquals((long)989L, (long)snapshot.get98thPercentile());
        Assert.assertEquals((long)994L, (long)snapshot.get99thPercentile());
        Assert.assertEquals((long)998L, (long)snapshot.get999thPercentile());
    }
}

