/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.monkies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.Policy;
import org.apache.hadoop.hbase.util.Pair;

public class PolicyBasedChaosMonkey
extends ChaosMonkey {
    private static final Log LOG = LogFactory.getLog(PolicyBasedChaosMonkey.class);
    private static final long ONE_SEC = 1000L;
    private static final long FIVE_SEC = 5000L;
    private static final long ONE_MIN = 60000L;
    public static final long TIMEOUT = 60000L;
    final IntegrationTestingUtility util;
    private Policy[] policies;
    private Thread[] monkeyThreads;

    public PolicyBasedChaosMonkey(IntegrationTestingUtility util, Policy ... policies) {
        this.util = util;
        this.policies = policies;
    }

    public PolicyBasedChaosMonkey(IntegrationTestingUtility util, Collection<Policy> policies) {
        this.util = util;
        this.policies = policies.toArray(new Policy[policies.size()]);
    }

    public static <T> T selectRandomItem(T[] items) {
        return items[RandomUtils.nextInt((int)items.length)];
    }

    public static <T> T selectWeightedRandomItem(List<Pair<T, Integer>> items) {
        int totalWeight = 0;
        for (Pair<T, Integer> pair : items) {
            totalWeight += ((Integer)pair.getSecond()).intValue();
        }
        int cutoff = RandomUtils.nextInt((int)totalWeight);
        int cummulative = 0;
        Object item = null;
        for (int i = 0; i < items.size(); ++i) {
            int curWeight = (Integer)items.get(i).getSecond();
            if (cutoff < cummulative + curWeight) {
                item = items.get(i).getFirst();
                break;
            }
            cummulative += curWeight;
        }
        return (T)item;
    }

    public static <T> List<T> selectRandomItems(T[] items, float ratio) {
        int remaining = (int)Math.ceil((float)items.length * ratio);
        ArrayList<T> selectedItems = new ArrayList<T>(remaining);
        for (int i = 0; i < items.length && remaining > 0; ++i) {
            if (!(RandomUtils.nextFloat() < (float)remaining / (float)(items.length - i))) continue;
            selectedItems.add(items[i]);
            --remaining;
        }
        return selectedItems;
    }

    @Override
    public void start() throws Exception {
        this.monkeyThreads = new Thread[this.policies.length];
        for (int i = 0; i < this.policies.length; ++i) {
            this.policies[i].init(new Policy.PolicyContext(this.util));
            Thread monkeyThread = new Thread((Runnable)this.policies[i], "ChaosMonkeyThread");
            monkeyThread.start();
            this.monkeyThreads[i] = monkeyThread;
        }
    }

    @Override
    public void stop(String why) {
        if (this.policies == null) {
            return;
        }
        for (Policy policy : this.policies) {
            policy.stop(why);
        }
    }

    @Override
    public boolean isStopped() {
        return this.policies[0].isStopped();
    }

    @Override
    public void waitForStop() throws InterruptedException {
        if (this.monkeyThreads == null) {
            return;
        }
        for (Thread monkeyThread : this.monkeyThreads) {
            monkeyThread.join();
        }
    }

    @Override
    public boolean isDestructive() {
        return true;
    }
}

