/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import com.yammer.metrics.core.Histogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.PerformanceEvaluation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.MoveRandomRegionOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomRsExceptMetaAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.YammerHistogramUtils;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestRegionReplicaPerf
extends IntegrationTestBase {
    private static final Log LOG = LogFactory.getLog(IntegrationTestRegionReplicaPerf.class);
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"info");
    private static final String SLEEP_TIME_KEY = "sleeptime";
    private static final String SLEEP_TIME_DEFAULT = "10000";
    private static final String TABLE_NAME_KEY = "tableName";
    private static final String TABLE_NAME_DEFAULT = "IntegrationTestRegionReplicaPerf";
    private static final String REPLICA_COUNT_KEY = "replicas";
    private static final String REPLICA_COUNT_DEFAULT = "3";
    private static final String PRIMARY_TIMEOUT_KEY = "timeout";
    private static final String PRIMARY_TIMEOUT_DEFAULT = "10000";
    private static final String NUM_RS_KEY = "numRs";
    private static final String NUM_RS_DEFAULT = "3";
    private TableName tableName;
    private long sleepTime;
    private int replicaCount;
    private int primaryTimeout;
    private int clusterSize;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.util.getConfiguration();
        Assert.assertEquals((String)"Master must be configured with StochasticLoadBalancer", (Object)"org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer", (Object)conf.get("hbase.master.loadbalancer.class"));
        Assert.assertTrue((String)"hbase.regionserver.storefile.refresh.period must be greater than zero.", (conf.getLong("hbase.regionserver.storefile.refresh.period", 0L) > 0L ? 1 : 0) != 0);
        conf.setBoolean("hbase.ipc.client.specificThreadForWriting", true);
        conf.setLong("hbase.client.primaryCallTimeout.get", (long)this.primaryTimeout);
        conf.setLong("hbase.client.primaryCallTimeout.multiget", (long)this.primaryTimeout);
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        this.util.initializeCluster(this.clusterSize);
    }

    @Override
    public void setUpMonkey() throws Exception {
        PeriodicRandomActionPolicy p = new PeriodicRandomActionPolicy(this.sleepTime, new RestartRandomRsExceptMetaAction(this.sleepTime), new MoveRandomRegionOfTableAction(this.tableName));
        this.monkey = new PolicyBasedChaosMonkey(this.util, p);
    }

    @Override
    protected void addOptions() {
        this.addOptWithArg(TABLE_NAME_KEY, "Alternate table name. Default: 'IntegrationTestRegionReplicaPerf'");
        this.addOptWithArg(SLEEP_TIME_KEY, "How long the monkey sleeps between actions. Default: 10000");
        this.addOptWithArg(REPLICA_COUNT_KEY, "Number of region replicas. Default: 3");
        this.addOptWithArg(PRIMARY_TIMEOUT_KEY, "Overrides hbase.client.primaryCallTimeout. Default: 10000 (10ms)");
        this.addOptWithArg(NUM_RS_KEY, "Specify the number of RegionServers to use. Default: 3");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.tableName = TableName.valueOf((String)cmd.getOptionValue(TABLE_NAME_KEY, TABLE_NAME_DEFAULT));
        this.sleepTime = Long.parseLong(cmd.getOptionValue(SLEEP_TIME_KEY, "10000"));
        this.replicaCount = Integer.parseInt(cmd.getOptionValue(REPLICA_COUNT_KEY, "3"));
        this.primaryTimeout = Integer.parseInt(cmd.getOptionValue(PRIMARY_TIMEOUT_KEY, "10000"));
        this.clusterSize = Integer.parseInt(cmd.getOptionValue(NUM_RS_KEY, "3"));
        LOG.debug((Object)MoreObjects.toStringHelper((String)"Parsed Options").add(TABLE_NAME_KEY, (Object)this.tableName).add(SLEEP_TIME_KEY, this.sleepTime).add(REPLICA_COUNT_KEY, this.replicaCount).add(PRIMARY_TIMEOUT_KEY, this.primaryTimeout).add(NUM_RS_KEY, this.clusterSize).toString());
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        this.test();
        return 0;
    }

    @Override
    public TableName getTablename() {
        return this.tableName;
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])FAMILY_NAME)});
    }

    private static double calcMean(String desc, Stat stat, List<TimingResult> results) {
        double sum = 0.0;
        int count = 0;
        for (TimingResult tr : results) {
            for (PerformanceEvaluation.RunResult r : tr.results) {
                Assert.assertNotNull((String)"One of the run results is missing detailed run data.", (Object)r.hist);
                sum += stat.apply(r.hist);
                ++count;
                LOG.debug((Object)(desc + "{" + YammerHistogramUtils.getHistogramReport((Histogram)r.hist) + "}"));
            }
        }
        return sum / (double)count;
    }

    public void test() throws Exception {
        int i;
        int maxIters = 3;
        String replicas = "--replicas=" + this.replicaCount;
        String splitPolicy = "--splitPolicy=" + DisabledRegionSplitPolicy.class.getName();
        String writeOpts = String.format("%s --nomapred --table=%s --presplit=16 sequentialWrite 4", splitPolicy, this.tableName);
        String readOpts = String.format("--nomapred --table=%s --latency --sampleRate=0.1 randomRead 4", this.tableName);
        String replicaReadOpts = String.format("%s %s", replicas, readOpts);
        ArrayList<TimingResult> resultsWithoutReplicas = new ArrayList<TimingResult>(maxIters);
        ArrayList<TimingResult> resultsWithReplicas = new ArrayList<TimingResult>(maxIters);
        LOG.debug((Object)"Populating table.");
        new PerfEvalCallable((Admin)this.util.getHBaseAdmin(), writeOpts).call();
        Assert.assertEquals((String)"Table must be created with DisabledRegionSplitPolicy. Broken test.", (Object)DisabledRegionSplitPolicy.class.getName(), (Object)this.util.getHBaseAdmin().getTableDescriptor(this.tableName).getRegionSplitPolicyClassName());
        this.startMonkey();
        for (i = 0; i < maxIters; ++i) {
            LOG.debug((Object)("Launching non-replica job " + (i + 1) + "/" + maxIters));
            resultsWithoutReplicas.add(new PerfEvalCallable((Admin)this.util.getHBaseAdmin(), readOpts).call());
            Thread.sleep(5000L);
        }
        this.cleanUpMonkey("Altering table.");
        LOG.debug((Object)("Altering " + this.tableName + " replica count to " + this.replicaCount));
        IntegrationTestingUtility.setReplicas((Admin)this.util.getHBaseAdmin(), (TableName)this.tableName, (int)this.replicaCount);
        this.setUpMonkey();
        this.startMonkey();
        for (i = 0; i < maxIters; ++i) {
            LOG.debug((Object)("Launching replica job " + (i + 1) + "/" + maxIters));
            resultsWithReplicas.add(new PerfEvalCallable((Admin)this.util.getHBaseAdmin(), replicaReadOpts).call());
            Thread.sleep(5000L);
        }
        double withoutReplicasStdevMean = IntegrationTestRegionReplicaPerf.calcMean("withoutReplicas", Stat.STDEV, resultsWithoutReplicas);
        double withoutReplicas9999Mean = IntegrationTestRegionReplicaPerf.calcMean("withoutReplicas", Stat.FOUR_9S, resultsWithoutReplicas);
        double withReplicasStdevMean = IntegrationTestRegionReplicaPerf.calcMean("withReplicas", Stat.STDEV, resultsWithReplicas);
        double withReplicas9999Mean = IntegrationTestRegionReplicaPerf.calcMean("withReplicas", Stat.FOUR_9S, resultsWithReplicas);
        LOG.info((Object)MoreObjects.toStringHelper((Object)((Object)this)).add("withoutReplicas", resultsWithoutReplicas).add("withReplicas", resultsWithReplicas).add("withoutReplicasStdevMean", withoutReplicasStdevMean).add("withoutReplicas99.99Mean", withoutReplicas9999Mean).add("withReplicasStdevMean", withReplicasStdevMean).add("withReplicas99.99Mean", withReplicas9999Mean).toString());
        Assert.assertTrue((String)("Running with region replicas under chaos should have less request variance than without. withReplicas.stdev.mean: " + withReplicasStdevMean + "ms withoutReplicas.stdev.mean: " + withoutReplicasStdevMean + "ms."), (withReplicasStdevMean <= withoutReplicasStdevMean ? 1 : 0) != 0);
        Assert.assertTrue((String)("Running with region replicas under chaos should improve 99.99pct latency. withReplicas.99.99.mean: " + withReplicas9999Mean + "ms withoutReplicas.99.99.mean: " + withoutReplicas9999Mean + "ms."), (withReplicas9999Mean <= withoutReplicas9999Mean ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int status = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestRegionReplicaPerf(), (String[])args);
        System.exit(status);
    }

    static class TimingResult {
        public final long numRows;
        public final long elapsedTime;
        public final PerformanceEvaluation.RunResult[] results;

        public TimingResult(long numRows, long elapsedTime, PerformanceEvaluation.RunResult[] results) {
            this.numRows = numRows;
            this.elapsedTime = elapsedTime;
            this.results = results;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("numRows", this.numRows).add("elapsedTime", this.elapsedTime).toString();
        }
    }

    static class PerfEvalCallable
    implements Callable<TimingResult> {
        private final Queue<String> argv = new LinkedList<String>();
        private final Admin admin;

        public PerfEvalCallable(Admin admin, String argv) {
            this.admin = admin;
            this.argv.addAll(Arrays.asList(argv.split(" ")));
            LOG.debug((Object)("Created PerformanceEvaluationCallable with args: " + argv));
        }

        @Override
        public TimingResult call() throws Exception {
            PerformanceEvaluation.TestOptions opts = PerformanceEvaluation.parseOpts(this.argv);
            PerformanceEvaluation.checkTable((Admin)this.admin, (PerformanceEvaluation.TestOptions)opts);
            PerformanceEvaluation.RunResult[] results = null;
            long numRows = opts.totalRows;
            long elapsedTime = 0L;
            if (opts.nomapred) {
                for (PerformanceEvaluation.RunResult r : results = PerformanceEvaluation.doLocalClients((PerformanceEvaluation.TestOptions)opts, (Configuration)this.admin.getConfiguration())) {
                    elapsedTime = Math.max(elapsedTime, r.duration);
                }
            } else {
                Job job = PerformanceEvaluation.doMapReduce((PerformanceEvaluation.TestOptions)opts, (Configuration)this.admin.getConfiguration());
                Counters counters = job.getCounters();
                numRows = counters.findCounter((Enum)PerformanceEvaluation.Counter.ROWS).getValue();
                elapsedTime = counters.findCounter((Enum)PerformanceEvaluation.Counter.ELAPSED_TIME).getValue();
            }
            return new TimingResult(numRows, elapsedTime, results);
        }
    }

    private static enum Stat {
        STDEV{

            @Override
            double apply(Histogram hist) {
                return hist.stdDev();
            }
        }
        ,
        FOUR_9S{

            @Override
            double apply(Histogram hist) {
                return hist.getSnapshot().getValue(0.9999);
            }
        };


        abstract double apply(Histogram var1);
    }
}

