/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.Size;
import org.apache.hadoop.hbase.hbtop.screen.top.Summary;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.junit.Assert;

public final class TestUtils {
    static final String HBASE_VERSION = "1.5.0-SNAPSHOT";
    static final String CLUSTER_UUID = "01234567-89ab-cdef-0123-456789abcdef";

    private TestUtils() {
    }

    public static ClusterStatus createDummyClusterStatus() {
        HashMap serverLoads = Maps.newHashMap();
        ArrayList deadServers = Lists.newArrayList();
        HashSet rit = Sets.newHashSet();
        ServerName host1 = ServerName.valueOf((String)"host1.apache.com", (int)1000, (long)1L);
        serverLoads.put(host1, TestUtils.createServerLoad(100L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 100L, Lists.newArrayList((Object[])new ClusterStatusProtos.RegionLoad[]{TestUtils.createRegionLoad("table1,,1.00000000000000000000000000000000.", 100L, 100L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 1, new Size(100.0, Size.Unit.MEGABYTE), 0.1f, 100L, 100L, "2019-07-22 00:00:00"), TestUtils.createRegionLoad("table2,1,2.00000000000000000000000000000001.", 200L, 200L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 0.2f, 50L, 200L, "2019-07-22 00:00:01"), TestUtils.createRegionLoad("namespace:table3,,3_0001.00000000000000000000000000000002.", 300L, 300L, new Size(300.0, Size.Unit.MEGABYTE), new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(300.0, Size.Unit.MEGABYTE), 0.3f, 100L, 300L, "2019-07-22 00:00:02")})));
        ServerName host2 = ServerName.valueOf((String)"host2.apache.com", (int)1001, (long)2L);
        serverLoads.put(host2, TestUtils.createServerLoad(200L, new Size(16.0, Size.Unit.GIGABYTE), new Size(32.0, Size.Unit.GIGABYTE), 200L, Lists.newArrayList((Object[])new ClusterStatusProtos.RegionLoad[]{TestUtils.createRegionLoad("table1,1,4.00000000000000000000000000000003.", 100L, 100L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 1, new Size(100.0, Size.Unit.MEGABYTE), 0.4f, 50L, 100L, "2019-07-22 00:00:03"), TestUtils.createRegionLoad("table2,,5.00000000000000000000000000000004.", 200L, 200L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 0.5f, 150L, 200L, "2019-07-22 00:00:04"), TestUtils.createRegionLoad("namespace:table3,,6.00000000000000000000000000000005.", 300L, 300L, new Size(300.0, Size.Unit.MEGABYTE), new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(300.0, Size.Unit.MEGABYTE), 0.6f, 200L, 300L, "2019-07-22 00:00:05")})));
        ServerName host3 = ServerName.valueOf((String)"host3.apache.com", (int)1002, (long)3L);
        deadServers.add(host3);
        rit.add(new RegionState(new HRegionInfo(0L, TableName.valueOf((String)"table4"), 0), RegionState.State.OFFLINE, host3));
        return new ClusterStatus(HBASE_VERSION, CLUSTER_UUID, (Map)serverLoads, (Collection)deadServers, null, null, (Set)rit, new String[0], Boolean.valueOf(true));
    }

    private static ClusterStatusProtos.RegionLoad createRegionLoad(String regionName, long readRequestCount, long writeRequestCount, Size storeFileSize, Size uncompressedStoreFileSize, int storeFileCount, Size memStoreSize, float locality, long compactedCellCount, long compactingCellCount, String lastMajorCompactionTime) {
        FastDateFormat df = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        try {
            return ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).setValue(ByteString.copyFromUtf8((String)regionName)).build()).setReadRequestsCount(readRequestCount).setWriteRequestsCount(writeRequestCount).setStorefileSizeMB((int)storeFileSize.get(Size.Unit.MEGABYTE)).setStoreUncompressedSizeMB((int)uncompressedStoreFileSize.get(Size.Unit.MEGABYTE)).setStorefiles(storeFileCount).setMemstoreSizeMB((int)memStoreSize.get(Size.Unit.MEGABYTE)).setDataLocality(locality).setCurrentCompactedKVs(compactedCellCount).setTotalCompactingKVs(compactingCellCount).setLastMajorCompactionTs(df.parse(lastMajorCompactionTime).getTime()).build();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static ServerLoad createServerLoad(long reportTimestamp, Size usedHeapSize, Size maxHeapSize, long requestCountPerSecond, List<ClusterStatusProtos.RegionLoad> regionLoads) {
        return new ServerLoad(ClusterStatusProtos.ServerLoad.newBuilder().setReportStartTime(reportTimestamp).setReportEndTime(reportTimestamp).setUsedHeapMB((int)usedHeapSize.get(Size.Unit.MEGABYTE)).setMaxHeapMB((int)maxHeapSize.get(Size.Unit.MEGABYTE)).setNumberOfRequests(requestCountPerSecond).addAllRegionLoads(regionLoads).build());
    }

    public static void assertRecordsInRegionMode(List<Record> records) {
        Assert.assertEquals((long)6L, (long)records.size());
        block16: for (Record record : records) {
            switch (record.get((Object)Field.REGION_NAME).asString()) {
                case "table1,,1.00000000000000000000000000000000.": {
                    TestUtils.assertRecordInRegionMode(record, "default", "1", "", "table1", "00000000000000000000000000000000", "host1:1000", "host1.apache.com,1000,1", 0L, 0L, 0L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 1, new Size(100.0, Size.Unit.MEGABYTE), 0.1f, "", 100L, 100L, 100.0f, "2019-07-22 00:00:00");
                    continue block16;
                }
                case "table1,1,4.00000000000000000000000000000003.": {
                    TestUtils.assertRecordInRegionMode(record, "default", "4", "", "table1", "00000000000000000000000000000003", "host2:1001", "host2.apache.com,1001,2", 0L, 0L, 0L, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE), 1, new Size(100.0, Size.Unit.MEGABYTE), 0.4f, "1", 100L, 50L, 50.0f, "2019-07-22 00:00:03");
                    continue block16;
                }
                case "table2,,5.00000000000000000000000000000004.": {
                    TestUtils.assertRecordInRegionMode(record, "default", "5", "", "table2", "00000000000000000000000000000004", "host2:1001", "host2.apache.com,1001,2", 0L, 0L, 0L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 0.5f, "", 200L, 150L, 75.0f, "2019-07-22 00:00:04");
                    continue block16;
                }
                case "table2,1,2.00000000000000000000000000000001.": {
                    TestUtils.assertRecordInRegionMode(record, "default", "2", "", "table2", "00000000000000000000000000000001", "host1:1000", "host1.apache.com,1000,1", 0L, 0L, 0L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 0.2f, "1", 200L, 50L, 25.0f, "2019-07-22 00:00:01");
                    continue block16;
                }
                case "namespace:table3,,6.00000000000000000000000000000005.": {
                    TestUtils.assertRecordInRegionMode(record, "namespace", "6", "", "table3", "00000000000000000000000000000005", "host2:1001", "host2.apache.com,1001,2", 0L, 0L, 0L, new Size(300.0, Size.Unit.MEGABYTE), new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(300.0, Size.Unit.MEGABYTE), 0.6f, "", 300L, 200L, 66.66667f, "2019-07-22 00:00:05");
                    continue block16;
                }
                case "namespace:table3,,3_0001.00000000000000000000000000000002.": {
                    TestUtils.assertRecordInRegionMode(record, "namespace", "3", "1", "table3", "00000000000000000000000000000002", "host1:1000", "host1.apache.com,1000,1", 0L, 0L, 0L, new Size(300.0, Size.Unit.MEGABYTE), new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(300.0, Size.Unit.MEGABYTE), 0.3f, "", 300L, 100L, 33.333336f, "2019-07-22 00:00:02");
                    continue block16;
                }
            }
            Assert.fail();
        }
    }

    private static void assertRecordInRegionMode(Record record, String namespace, String startCode, String replicaId, String table, String region, String regionServer, String longRegionServer, long requestCountPerSecond, long readRequestCountPerSecond, long writeCountRequestPerSecond, Size storeFileSize, Size uncompressedStoreFileSize, int numStoreFiles, Size memStoreSize, float locality, String startKey, long compactingCellCount, long compactedCellCount, float compactionProgress, String lastMajorCompactionTime) {
        Assert.assertEquals((long)21L, (long)record.size());
        Assert.assertEquals((Object)namespace, (Object)record.get((Object)Field.NAMESPACE).asString());
        Assert.assertEquals((Object)startCode, (Object)record.get((Object)Field.START_CODE).asString());
        Assert.assertEquals((Object)replicaId, (Object)record.get((Object)Field.REPLICA_ID).asString());
        Assert.assertEquals((Object)table, (Object)record.get((Object)Field.TABLE).asString());
        Assert.assertEquals((Object)region, (Object)record.get((Object)Field.REGION).asString());
        Assert.assertEquals((Object)regionServer, (Object)record.get((Object)Field.REGION_SERVER).asString());
        Assert.assertEquals((Object)longRegionServer, (Object)record.get((Object)Field.LONG_REGION_SERVER).asString());
        Assert.assertEquals((long)requestCountPerSecond, (long)record.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((long)readRequestCountPerSecond, (long)record.get((Object)Field.READ_REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((long)writeCountRequestPerSecond, (long)record.get((Object)Field.WRITE_REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((Object)storeFileSize, (Object)record.get((Object)Field.STORE_FILE_SIZE).asSize());
        Assert.assertEquals((Object)uncompressedStoreFileSize, (Object)record.get((Object)Field.UNCOMPRESSED_STORE_FILE_SIZE).asSize());
        Assert.assertEquals((long)numStoreFiles, (long)record.get((Object)Field.NUM_STORE_FILES).asInt());
        Assert.assertEquals((Object)record.get((Object)Field.MEM_STORE_SIZE).asSize(), (Object)memStoreSize);
        Assert.assertEquals((double)locality, (double)record.get((Object)Field.LOCALITY).asFloat(), (double)0.001);
        Assert.assertEquals((Object)startKey, (Object)record.get((Object)Field.START_KEY).asString());
        Assert.assertEquals((long)compactingCellCount, (long)record.get((Object)Field.COMPACTING_CELL_COUNT).asLong());
        Assert.assertEquals((long)compactedCellCount, (long)record.get((Object)Field.COMPACTED_CELL_COUNT).asLong());
        Assert.assertEquals((double)compactionProgress, (double)record.get((Object)Field.COMPACTION_PROGRESS).asFloat(), (double)0.001);
        Assert.assertEquals((Object)lastMajorCompactionTime, (Object)record.get((Object)Field.LAST_MAJOR_COMPACTION_TIME).asString());
    }

    public static void assertRecordsInNamespaceMode(List<Record> records) {
        Assert.assertEquals((long)2L, (long)records.size());
        block8: for (Record record : records) {
            switch (record.get((Object)Field.NAMESPACE).asString()) {
                case "default": {
                    TestUtils.assertRecordInNamespaceMode(record, 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 4);
                    continue block8;
                }
                case "namespace": {
                    TestUtils.assertRecordInNamespaceMode(record, 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 2);
                    continue block8;
                }
            }
            Assert.fail();
        }
    }

    private static void assertRecordInNamespaceMode(Record record, long requestCountPerSecond, long readRequestCountPerSecond, long writeCountRequestPerSecond, Size storeFileSize, Size uncompressedStoreFileSize, int numStoreFiles, Size memStoreSize, int regionCount) {
        Assert.assertEquals((long)9L, (long)record.size());
        Assert.assertEquals((long)requestCountPerSecond, (long)record.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((long)readRequestCountPerSecond, (long)record.get((Object)Field.READ_REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((long)writeCountRequestPerSecond, (long)record.get((Object)Field.WRITE_REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((Object)storeFileSize, (Object)record.get((Object)Field.STORE_FILE_SIZE).asSize());
        Assert.assertEquals((Object)uncompressedStoreFileSize, (Object)record.get((Object)Field.UNCOMPRESSED_STORE_FILE_SIZE).asSize());
        Assert.assertEquals((long)numStoreFiles, (long)record.get((Object)Field.NUM_STORE_FILES).asInt());
        Assert.assertEquals((Object)memStoreSize, (Object)record.get((Object)Field.MEM_STORE_SIZE).asSize());
        Assert.assertEquals((long)regionCount, (long)record.get((Object)Field.REGION_COUNT).asInt());
    }

    public static void assertRecordsInTableMode(List<Record> records) {
        Assert.assertEquals((long)3L, (long)records.size());
        block10: for (Record record : records) {
            String tableName;
            switch (tableName = String.format("%s:%s", record.get((Object)Field.NAMESPACE).asString(), record.get((Object)Field.TABLE).asString())) {
                case "default:table1": {
                    TestUtils.assertRecordInTableMode(record, 0L, 0L, 0L, new Size(200.0, Size.Unit.MEGABYTE), new Size(400.0, Size.Unit.MEGABYTE), 2, new Size(200.0, Size.Unit.MEGABYTE), 2);
                    continue block10;
                }
                case "default:table2": {
                    TestUtils.assertRecordInTableMode(record, 0L, 0L, 0L, new Size(400.0, Size.Unit.MEGABYTE), new Size(800.0, Size.Unit.MEGABYTE), 4, new Size(400.0, Size.Unit.MEGABYTE), 2);
                    continue block10;
                }
                case "namespace:table3": {
                    TestUtils.assertRecordInTableMode(record, 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 2);
                    continue block10;
                }
            }
            Assert.fail();
        }
    }

    private static void assertRecordInTableMode(Record record, long requestCountPerSecond, long readRequestCountPerSecond, long writeCountRequestPerSecond, Size storeFileSize, Size uncompressedStoreFileSize, int numStoreFiles, Size memStoreSize, int regionCount) {
        Assert.assertEquals((long)10L, (long)record.size());
        Assert.assertEquals((long)requestCountPerSecond, (long)record.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((long)readRequestCountPerSecond, (long)record.get((Object)Field.READ_REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((long)writeCountRequestPerSecond, (long)record.get((Object)Field.WRITE_REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((Object)storeFileSize, (Object)record.get((Object)Field.STORE_FILE_SIZE).asSize());
        Assert.assertEquals((Object)uncompressedStoreFileSize, (Object)record.get((Object)Field.UNCOMPRESSED_STORE_FILE_SIZE).asSize());
        Assert.assertEquals((long)numStoreFiles, (long)record.get((Object)Field.NUM_STORE_FILES).asInt());
        Assert.assertEquals((Object)memStoreSize, (Object)record.get((Object)Field.MEM_STORE_SIZE).asSize());
        Assert.assertEquals((long)regionCount, (long)record.get((Object)Field.REGION_COUNT).asInt());
    }

    public static void assertRecordsInRegionServerMode(List<Record> records) {
        Assert.assertEquals((long)2L, (long)records.size());
        block8: for (Record record : records) {
            switch (record.get((Object)Field.REGION_SERVER).asString()) {
                case "host1:1000": {
                    TestUtils.assertRecordInRegionServerMode(record, "host1.apache.com,1000,1", 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(100.0, Size.Unit.MEGABYTE), new Size(200.0, Size.Unit.MEGABYTE));
                    continue block8;
                }
                case "host2:1001": {
                    TestUtils.assertRecordInRegionServerMode(record, "host2.apache.com,1001,2", 0L, 0L, 0L, new Size(600.0, Size.Unit.MEGABYTE), new Size(1200.0, Size.Unit.MEGABYTE), 6, new Size(600.0, Size.Unit.MEGABYTE), 3, new Size(16.0, Size.Unit.GIGABYTE), new Size(32.0, Size.Unit.GIGABYTE));
                    continue block8;
                }
            }
            Assert.fail();
        }
    }

    private static void assertRecordInRegionServerMode(Record record, String longRegionServer, long requestCountPerSecond, long readRequestCountPerSecond, long writeCountRequestPerSecond, Size storeFileSize, Size uncompressedStoreFileSize, int numStoreFiles, Size memStoreSize, int regionCount, Size usedHeapSize, Size maxHeapSize) {
        Assert.assertEquals((long)12L, (long)record.size());
        Assert.assertEquals((Object)longRegionServer, (Object)record.get((Object)Field.LONG_REGION_SERVER).asString());
        Assert.assertEquals((long)requestCountPerSecond, (long)record.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((long)readRequestCountPerSecond, (long)record.get((Object)Field.READ_REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((long)writeCountRequestPerSecond, (long)record.get((Object)Field.WRITE_REQUEST_COUNT_PER_SECOND).asLong());
        Assert.assertEquals((Object)storeFileSize, (Object)record.get((Object)Field.STORE_FILE_SIZE).asSize());
        Assert.assertEquals((Object)uncompressedStoreFileSize, (Object)record.get((Object)Field.UNCOMPRESSED_STORE_FILE_SIZE).asSize());
        Assert.assertEquals((long)numStoreFiles, (long)record.get((Object)Field.NUM_STORE_FILES).asInt());
        Assert.assertEquals((Object)memStoreSize, (Object)record.get((Object)Field.MEM_STORE_SIZE).asSize());
        Assert.assertEquals((long)regionCount, (long)record.get((Object)Field.REGION_COUNT).asInt());
        Assert.assertEquals((Object)usedHeapSize, (Object)record.get((Object)Field.USED_HEAP_SIZE).asSize());
        Assert.assertEquals((Object)maxHeapSize, (Object)record.get((Object)Field.MAX_HEAP_SIZE).asSize());
    }

    public static void assertSummary(Summary summary) {
        Assert.assertEquals((Object)HBASE_VERSION, (Object)summary.getVersion());
        Assert.assertEquals((Object)CLUSTER_UUID, (Object)summary.getClusterId());
        Assert.assertEquals((long)3L, (long)summary.getServers());
        Assert.assertEquals((long)2L, (long)summary.getLiveServers());
        Assert.assertEquals((long)1L, (long)summary.getDeadServers());
        Assert.assertEquals((long)6L, (long)summary.getRegionCount());
        Assert.assertEquals((long)1L, (long)summary.getRitCount());
        Assert.assertEquals((double)3.0, (double)summary.getAverageLoad(), (double)0.001);
        Assert.assertEquals((long)300L, (long)summary.getAggregateRequestPerSecond());
    }
}

