/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.terminal.impl;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalPrinter;
import org.apache.hadoop.hbase.hbtop.terminal.impl.TerminalImpl;

public final class TestTerminalPrinter {
    private TestTerminalPrinter() {
    }

    public static void main(String[] args) throws Exception {
        try (TerminalImpl terminal = new TerminalImpl();){
            KeyPress keyPress;
            terminal.hideCursor();
            terminal.refresh();
            TerminalPrinter printer = terminal.getTerminalPrinter(0);
            printer.print("Normal string").endOfLine();
            printer.startHighlight().print("Highlighted string").stopHighlight().endOfLine();
            printer.startBold().print("Bold string").stopBold().endOfLine();
            printer.startHighlight().startBold().print("Highlighted bold string").stopBold().stopHighlight().endOfLine();
            printer.endOfLine();
            printer.print("Press any key to finish").endOfLine();
            terminal.refresh();
            while ((keyPress = terminal.pollKeyPress()) == null) {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
    }
}

