/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.List;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.TestUtils;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.TestModeBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRegionServerMode
extends TestModeBase {
    @Override
    protected Mode getMode() {
        return Mode.REGION_SERVER;
    }

    @Override
    protected void assertRecords(List<Record> records) {
        TestUtils.assertRecordsInRegionServerMode(records);
    }

    @Override
    protected void assertDrillDown(Record currentRecord, DrillDownInfo drillDownInfo) {
        Assert.assertThat((Object)drillDownInfo.getNextMode(), (Matcher)CoreMatchers.is((Object)Mode.REGION));
        Assert.assertThat((Object)drillDownInfo.getInitialFilters().size(), (Matcher)CoreMatchers.is((Object)1));
        switch (currentRecord.get((Object)Field.REGION_SERVER).asString()) {
            case "host1:1000": {
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"RS==host1:1000"));
                break;
            }
            case "host2:1001": {
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"RS==host2:1001"));
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }
}

