/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.FilterDisplayModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.screen.top.FilterDisplayModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestFilterDisplayModeScreenPresenter {
    @Mock
    private FilterDisplayModeScreenView filterDisplayModeScreenView;
    @Mock
    private TopScreenView topScreenView;
    private FilterDisplayModeScreenPresenter filterDisplayModeScreenPresenter;

    @Before
    public void setup() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FieldInfo fieldInfo : Mode.REGION.getFieldInfos()) {
            fields.add(fieldInfo.getField());
        }
        ArrayList<RecordFilter> filters = new ArrayList<RecordFilter>();
        filters.add(RecordFilter.parse((String)"NAMESPACE==namespace", fields, (boolean)true));
        filters.add(RecordFilter.parse((String)"TABLE==table", fields, (boolean)true));
        this.filterDisplayModeScreenPresenter = new FilterDisplayModeScreenPresenter(this.filterDisplayModeScreenView, filters, (ScreenView)this.topScreenView);
    }

    @Test
    public void testInit() {
        this.filterDisplayModeScreenPresenter.init();
        ((FilterDisplayModeScreenView)Mockito.verify((Object)this.filterDisplayModeScreenView)).showFilters((List)Mockito.argThat((Matcher)new ArgumentMatcher<List<RecordFilter>>(){

            public boolean matches(Object argument) {
                List filters = (List)argument;
                return filters.size() == 2 && ((RecordFilter)filters.get(0)).toString().equals("NAMESPACE==namespace") && ((RecordFilter)filters.get(1)).toString().equals("TABLE==table");
            }
        }));
    }

    @Test
    public void testReturnToTopScreen() {
        Assert.assertThat((Object)this.filterDisplayModeScreenPresenter.returnToNextScreen(), (Matcher)CoreMatchers.is((Object)this.topScreenView));
    }
}

