/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop;

import java.util.Map;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRecord {
    @Test
    public void testBuilder() {
        Record actual1 = Record.builder().put(Field.TABLE, (Object)"tableName").put(Record.entry((Field)Field.REGION_COUNT, (Object)3)).put(Field.REQUEST_COUNT_PER_SECOND, Field.REQUEST_COUNT_PER_SECOND.newValue((Object)100L)).build();
        Assert.assertThat((Object)actual1.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)actual1.get((Object)Field.TABLE).asString(), (Matcher)CoreMatchers.is((Object)"tableName"));
        Assert.assertThat((Object)actual1.get((Object)Field.REGION_COUNT).asInt(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)actual1.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)100L));
        Record actual2 = Record.builder().putAll((Map)actual1).build();
        Assert.assertThat((Object)actual2.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)actual2.get((Object)Field.TABLE).asString(), (Matcher)CoreMatchers.is((Object)"tableName"));
        Assert.assertThat((Object)actual2.get((Object)Field.REGION_COUNT).asInt(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)actual2.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)100L));
    }

    @Test
    public void testOfEntries() {
        Record actual = Record.ofEntries((Record.Entry[])new Record.Entry[]{Record.entry((Field)Field.TABLE, (Object)"tableName"), Record.entry((Field)Field.REGION_COUNT, (Object)3), Record.entry((Field)Field.REQUEST_COUNT_PER_SECOND, (Object)100L)});
        Assert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)actual.get((Object)Field.TABLE).asString(), (Matcher)CoreMatchers.is((Object)"tableName"));
        Assert.assertThat((Object)actual.get((Object)Field.REGION_COUNT).asInt(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)actual.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)100L));
    }

    @Test
    public void testCombine() {
        Record record1 = Record.ofEntries((Record.Entry[])new Record.Entry[]{Record.entry((Field)Field.TABLE, (Object)"tableName"), Record.entry((Field)Field.REGION_COUNT, (Object)3), Record.entry((Field)Field.REQUEST_COUNT_PER_SECOND, (Object)100L)});
        Record record2 = Record.ofEntries((Record.Entry[])new Record.Entry[]{Record.entry((Field)Field.TABLE, (Object)"tableName"), Record.entry((Field)Field.REGION_COUNT, (Object)5), Record.entry((Field)Field.REQUEST_COUNT_PER_SECOND, (Object)500L)});
        Record actual = record1.combine(record2);
        Assert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)actual.get((Object)Field.TABLE).asString(), (Matcher)CoreMatchers.is((Object)"tableName"));
        Assert.assertThat((Object)actual.get((Object)Field.REGION_COUNT).asInt(), (Matcher)CoreMatchers.is((Object)8));
        Assert.assertThat((Object)actual.get((Object)Field.REQUEST_COUNT_PER_SECOND).asLong(), (Matcher)CoreMatchers.is((Object)600L));
    }
}

