/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.terminal;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class KeyPress {
    private final Type type;
    private final Character character;
    private final boolean alt;
    private final boolean ctrl;
    private final boolean shift;

    public KeyPress(Type type, @Nullable Character character, boolean alt, boolean ctrl, boolean shift) {
        this.type = Objects.requireNonNull(type);
        this.character = character;
        this.alt = alt;
        this.ctrl = ctrl;
        this.shift = shift;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public Character getCharacter() {
        return this.character;
    }

    public boolean isAlt() {
        return this.alt;
    }

    public boolean isCtrl() {
        return this.ctrl;
    }

    public boolean isShift() {
        return this.shift;
    }

    public String toString() {
        return "KeyPress{type=" + this.type + ", character=" + this.escape(this.character) + ", alt=" + this.alt + ", ctrl=" + this.ctrl + ", shift=" + this.shift + "}";
    }

    private String escape(Character character) {
        if (character == null) {
            return "null";
        }
        switch (character.charValue()) {
            case '\n': {
                return "\\n";
            }
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
        }
        return character.toString();
    }

    public static enum Type {
        Character,
        Escape,
        Backspace,
        ArrowLeft,
        ArrowRight,
        ArrowUp,
        ArrowDown,
        Insert,
        Delete,
        Home,
        End,
        PageUp,
        PageDown,
        ReverseTab,
        Tab,
        Enter,
        F1,
        F2,
        F3,
        F4,
        F5,
        F6,
        F7,
        F8,
        F9,
        F10,
        F11,
        F12,
        Unknown;

    }
}

