/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.field.Size;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.RegionModeStrategy;

@InterfaceAudience.Private
public final class RegionServerModeStrategy
implements ModeStrategy {
    private final List<FieldInfo> fieldInfos = Arrays.asList(new FieldInfo(Field.REGION_SERVER, 0, true), new FieldInfo(Field.LONG_REGION_SERVER, 0, false), new FieldInfo(Field.REGION_COUNT, 7, true), new FieldInfo(Field.REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.READ_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.WRITE_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.STORE_FILE_SIZE, 13, true), new FieldInfo(Field.UNCOMPRESSED_STORE_FILE_SIZE, 15, false), new FieldInfo(Field.NUM_STORE_FILES, 7, true), new FieldInfo(Field.MEM_STORE_SIZE, 11, true), new FieldInfo(Field.USED_HEAP_SIZE, 11, true), new FieldInfo(Field.MAX_HEAP_SIZE, 11, true));
    private final RegionModeStrategy regionModeStrategy = new RegionModeStrategy();

    RegionServerModeStrategy() {
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Field getDefaultSortField() {
        return Field.REQUEST_COUNT_PER_SECOND;
    }

    @Override
    public List<Record> getRecords(ClusterStatus clusterStatus) {
        ArrayList<Record> records = new ArrayList<Record>();
        for (Record record : this.regionModeStrategy.getRecords(clusterStatus)) {
            ArrayList<Record.Entry> entries = new ArrayList<Record.Entry>();
            for (FieldInfo fieldInfo : this.fieldInfos) {
                if (!record.containsKey((Object)fieldInfo.getField())) continue;
                entries.add(Record.entry(fieldInfo.getField(), record.get((Object)fieldInfo.getField())));
            }
            records.add(Record.builder().putAll(Record.ofEntries(entries)).put(Field.REGION_COUNT, 1).build());
        }
        HashMap<String, Record> retMap = new HashMap<String, Record>();
        for (Record record : records) {
            String regionServer = record.get((Object)Field.LONG_REGION_SERVER).asString();
            if (retMap.containsKey(regionServer)) {
                retMap.put(regionServer, ((Record)retMap.get(regionServer)).combine(record));
                continue;
            }
            retMap.put(regionServer, record);
        }
        for (ServerName sn : clusterStatus.getServers()) {
            Record record = (Record)retMap.get(sn.getServerName());
            if (record == null) continue;
            ServerLoad sl = clusterStatus.getLoad(sn);
            Record newRecord = Record.builder().putAll(record).put(Field.USED_HEAP_SIZE, new Size(sl.getUsedHeapMB(), Size.Unit.MEGABYTE)).put(Field.MAX_HEAP_SIZE, new Size(sl.getMaxHeapMB(), Size.Unit.MEGABYTE)).build();
            retMap.put(sn.getServerName(), newRecord);
        }
        return new ArrayList<Record>(retMap.values());
    }

    @Override
    public DrillDownInfo drillDown(Record selectedRecord) {
        List<RecordFilter> initialFilters = Collections.singletonList(RecordFilter.newBuilder(Field.REGION_SERVER).doubleEquals(selectedRecord.get((Object)Field.REGION_SERVER)));
        return new DrillDownInfo(Mode.REGION, initialFilters);
    }
}

