/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.RefreshHFilesProtos;
import org.apache.hadoop.hbase.regionserver.Store;

public class RefreshHFilesEndpoint
extends RefreshHFilesProtos.RefreshHFilesService
implements Coprocessor,
CoprocessorService {
    protected static final Log LOG = LogFactory.getLog(RefreshHFilesEndpoint.class);
    private RegionCoprocessorEnvironment env;

    public Service getService() {
        return this;
    }

    @Override
    public void refreshHFiles(RpcController controller, RefreshHFilesProtos.RefreshHFilesRequest request, RpcCallback<RefreshHFilesProtos.RefreshHFilesResponse> done) {
        try {
            for (Store store : this.env.getRegion().getStores()) {
                LOG.debug((Object)("Refreshing HFiles for region: " + store.getRegionInfo().getRegionNameAsString() + " and store: " + store.getColumnFamilyName() + "class:" + store.getClass()));
                store.refreshStoreFiles();
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"Exception while trying to refresh store files: ", (Throwable)ioe);
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run((Object)RefreshHFilesProtos.RefreshHFilesResponse.getDefaultInstance());
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

