/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.example.RefreshHFilesClient;
import org.apache.hadoop.hbase.coprocessor.example.RefreshHFilesEndpoint;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRefreshHFilesEndpoint {
    private static final Log LOG = LogFactory.getLog(TestRefreshHFilesEndpoint.class);
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static final int NUM_MASTER = 1;
    private static final int NUM_RS = 2;
    private static final TableName TABLE_NAME = TableName.valueOf((String)"testRefreshRegionHFilesEP");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");
    private static final byte[][] SPLIT_KEY = new byte[][]{Bytes.toBytes((String)"30")};
    private static final int NUM_ROWS = 5;
    private static final String HFILE_NAME = "123abcdef";
    private static Configuration CONF = HTU.getConfiguration();
    private static MiniHBaseCluster cluster;
    private static HTableDescriptor desc;
    private static Admin hbaseAdmin;
    private static HTable table;

    public static void setUp(String regionImpl) {
        try {
            CONF.set("hbase.hregion.impl", regionImpl);
            CONF.setInt("hbase.client.retries.number", 2);
            CONF.setStrings("hbase.coprocessor.region.classes", new String[]{RefreshHFilesEndpoint.class.getName()});
            cluster = HTU.startMiniCluster(1, 2);
            desc = new HTableDescriptor(TABLE_NAME);
            desc.addFamily(new HColumnDescriptor(FAMILY));
            hbaseAdmin = cluster.getMaster().getConnection().getAdmin();
            hbaseAdmin.createTable(desc, SPLIT_KEY);
            table = new HTable(HTU.getConfiguration(), TABLE_NAME);
            HTU.loadNumericRows((Table)table, FAMILY, 1, 20);
            HTU.flush(TABLE_NAME);
        }
        catch (Exception ex) {
            LOG.error((Object)"Couldn't finish setup", (Throwable)ex);
        }
    }

    @After
    public void tearDown() throws Exception {
        HTU.shutdownMiniCluster();
    }

    @Test
    public void testRefreshRegionHFilesEndpoint() throws Exception {
        TestRefreshHFilesEndpoint.setUp(HRegion.class.getName());
        Path tableDir = HTableDescriptor.getTableDir((Path)HTU.getDefaultRootDirPath(), (byte[])TABLE_NAME.toBytes());
        for (Region region : cluster.getRegions(TABLE_NAME)) {
            Path regionDir = new Path(tableDir, region.getRegionInfo().getEncodedName());
            Path familyDir = new Path(regionDir, Bytes.toString((byte[])FAMILY));
            HFileTestUtil.createHFile((Configuration)HTU.getConfiguration(), (FileSystem)HTU.getTestFileSystem(), (Path)new Path(familyDir, HFILE_NAME), (byte[])FAMILY, (byte[])QUALIFIER, (byte[])Bytes.toBytes((String)"50"), (byte[])Bytes.toBytes((String)"60"), (int)5);
        }
        Assert.assertEquals((long)2L, (long)HTU.getNumHFiles(TABLE_NAME, FAMILY));
        this.callRefreshRegionHFilesEndPoint();
        Assert.assertEquals((long)4L, (long)HTU.getNumHFiles(TABLE_NAME, FAMILY));
    }

    @Test(expected=IOException.class)
    public void testRefreshRegionHFilesEndpointWithException() throws IOException {
        TestRefreshHFilesEndpoint.setUp(HRegionForRefreshHFilesEP.class.getName());
        this.callRefreshRegionHFilesEndPoint();
    }

    private void callRefreshRegionHFilesEndPoint() throws IOException {
        try {
            RefreshHFilesClient refreshHFilesClient = new RefreshHFilesClient(CONF);
            refreshHFilesClient.refreshHFiles(TABLE_NAME);
        }
        catch (RetriesExhaustedException rex) {
            if (rex.getCause() instanceof IOException) {
                throw new IOException();
            }
        }
        catch (Throwable ex) {
            LOG.error((Object)ex);
            Assert.fail((String)"Couldn't call the RefreshRegionHFilesEndpoint");
        }
    }

    public static class HStoreWithFaultyRefreshHFilesAPI
    extends HStore {
        public HStoreWithFaultyRefreshHFilesAPI(HRegion region, HColumnDescriptor family, Configuration confParam) throws IOException {
            super(region, family, confParam);
        }

        public void refreshStoreFiles() throws IOException {
            throw new IOException();
        }
    }

    public static class HRegionForRefreshHFilesEP
    extends HRegion {
        HStoreWithFaultyRefreshHFilesAPI store;

        public HRegionForRefreshHFilesEP(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public List<Store> getStores() {
            ArrayList<Store> list = new ArrayList<Store>(this.stores.size());
            try {
                if (this.store == null) {
                    this.store = new HStoreWithFaultyRefreshHFilesAPI(this, new HColumnDescriptor(FAMILY), this.conf);
                }
                list.add((Store)this.store);
            }
            catch (IOException ioe) {
                LOG.info((Object)"Couldn't instantiate custom store implementation", (Throwable)ioe);
            }
            list.addAll(this.stores.values());
            return list;
        }
    }
}

