/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableUtils;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBytes
extends TestCase {
    public void testNullHashCode() {
        byte[] b = null;
        Exception ee = null;
        try {
            Bytes.hashCode(b);
        }
        catch (Exception e) {
            ee = e;
        }
        TestBytes.assertNotNull((Object)ee);
    }

    public void testAdd() throws Exception {
        byte[] a = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] b = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] c = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        byte[] d = new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        byte[] result1 = Bytes.add((byte[])a, (byte[])b, (byte[])c);
        byte[] result2 = Bytes.add((byte[][])new byte[][]{a, b, c});
        TestBytes.assertEquals((int)0, (int)Bytes.compareTo((byte[])result1, (byte[])result2));
        byte[] result4 = Bytes.add((byte[])result1, (byte[])d);
        byte[] result5 = Bytes.add((byte[][])new byte[][]{result1, d});
        TestBytes.assertEquals((int)0, (int)Bytes.compareTo((byte[])result1, (byte[])result2));
    }

    public void testSplit() throws Exception {
        int i;
        byte[] lowest = Bytes.toBytes((String)"AAA");
        byte[] middle = Bytes.toBytes((String)"CCC");
        byte[] highest = Bytes.toBytes((String)"EEE");
        byte[][] parts = Bytes.split((byte[])lowest, (byte[])highest, (int)1);
        for (i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString((byte[])parts[i]));
        }
        TestBytes.assertEquals((int)3, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals((byte[])parts[1], (byte[])middle));
        highest = Bytes.toBytes((String)"DDD");
        parts = Bytes.split((byte[])lowest, (byte[])highest, (int)2);
        for (i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString((byte[])parts[i]));
        }
        TestBytes.assertEquals((int)4, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals((byte[])parts[2], (byte[])middle));
    }

    public void testSplit2() throws Exception {
        byte[] lowest = Bytes.toBytes((String)"http://A");
        byte[] highest = Bytes.toBytes((String)"http://z");
        byte[] middle = Bytes.toBytes((String)"http://]");
        byte[][] parts = Bytes.split((byte[])lowest, (byte[])highest, (int)1);
        for (int i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString((byte[])parts[i]));
        }
        TestBytes.assertEquals((int)3, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals((byte[])parts[1], (byte[])middle));
    }

    public void testSplit3() throws Exception {
        byte[] low = new byte[]{1, 1, 1};
        byte[] high = new byte[]{1, 1, 3};
        try {
            Bytes.split((byte[])high, (byte[])low, (int)1);
            TestBytes.assertTrue((String)"Should not be able to split if low > high", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[][] parts = Bytes.split((byte[])low, (byte[])high, (int)1);
        for (int i = 0; i < parts.length; ++i) {
            System.out.println(i + " -> " + Bytes.toStringBinary((byte[])parts[i]));
        }
        TestBytes.assertTrue((String)("Returned split should have 3 parts but has " + parts.length), (parts.length == 3 ? 1 : 0) != 0);
        parts = Bytes.split((byte[])low, (byte[])high, (int)2);
        TestBytes.assertTrue((String)"Split with an additional byte", (parts != null ? 1 : 0) != 0);
        TestBytes.assertEquals((int)parts.length, (int)(low.length + 1));
        try {
            parts = Bytes.split((byte[])low, (byte[])high, (int)0);
            TestBytes.assertTrue((String)"Should not be able to split 0 times", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToInt() throws Exception {
        int[] ints = new int[]{-1, 123, Integer.MIN_VALUE, Integer.MAX_VALUE};
        for (int i = 0; i < ints.length; ++i) {
            byte[] b = Bytes.toBytes((int)ints[i]);
            TestBytes.assertEquals((int)ints[i], (int)Bytes.toInt((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((int)ints[i], (int)Bytes.toInt((byte[])b2, (int)1));
            TestBytes.assertEquals((int)ints[i], (int)Bytes.toInt((byte[])b2, (int)1, (int)4));
        }
    }

    public void testToLong() throws Exception {
        long[] longs = new long[]{-1L, 123L, Long.MIN_VALUE, Long.MAX_VALUE};
        for (int i = 0; i < longs.length; ++i) {
            byte[] b = Bytes.toBytes((long)longs[i]);
            TestBytes.assertEquals((long)longs[i], (long)Bytes.toLong((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((long)longs[i], (long)Bytes.toLong((byte[])b2, (int)1));
            TestBytes.assertEquals((long)longs[i], (long)Bytes.toLong((byte[])b2, (int)1, (int)8));
        }
    }

    public void testToFloat() throws Exception {
        float[] floats = new float[]{-1.0f, 123.123f, Float.MAX_VALUE};
        for (int i = 0; i < floats.length; ++i) {
            byte[] b = Bytes.toBytes((float)floats[i]);
            TestBytes.assertEquals((float)floats[i], (float)Bytes.toFloat((byte[])b), (float)0.0f);
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((float)floats[i], (float)Bytes.toFloat((byte[])b2, (int)1), (float)0.0f);
        }
    }

    public void testToDouble() throws Exception {
        double[] doubles = new double[]{Double.MIN_VALUE, Double.MAX_VALUE};
        for (int i = 0; i < doubles.length; ++i) {
            byte[] b = Bytes.toBytes((double)doubles[i]);
            TestBytes.assertEquals((double)doubles[i], (double)Bytes.toDouble((byte[])b), (double)0.0);
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((double)doubles[i], (double)Bytes.toDouble((byte[])b2, (int)1), (double)0.0);
        }
    }

    public void testToBigDecimal() throws Exception {
        BigDecimal[] decimals = new BigDecimal[]{new BigDecimal("-1"), new BigDecimal("123.123"), new BigDecimal("123123123123")};
        for (int i = 0; i < decimals.length; ++i) {
            byte[] b = Bytes.toBytes((BigDecimal)decimals[i]);
            TestBytes.assertEquals((Object)decimals[i], (Object)Bytes.toBigDecimal((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((Object)decimals[i], (Object)Bytes.toBigDecimal((byte[])b2, (int)1, (int)b.length));
        }
    }

    private byte[] bytesWithOffset(byte[] src) {
        byte[] result = new byte[src.length + 1];
        result[0] = -86;
        System.arraycopy(src, 0, result, 1, src.length);
        return result;
    }

    public void testToBytesForByteBuffer() {
        byte[] array = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteBuffer target = ByteBuffer.wrap(array);
        target.position(2);
        target.limit(7);
        byte[] actual = Bytes.toBytes((ByteBuffer)target);
        byte[] expected = new byte[]{0, 1, 2, 3, 4, 5, 6};
        TestBytes.assertTrue((boolean)Arrays.equals(expected, actual));
        TestBytes.assertEquals((int)2, (int)target.position());
        TestBytes.assertEquals((int)7, (int)target.limit());
        ByteBuffer target2 = target.slice();
        TestBytes.assertEquals((int)0, (int)target2.position());
        TestBytes.assertEquals((int)5, (int)target2.limit());
        byte[] actual2 = Bytes.toBytes((ByteBuffer)target2);
        byte[] expected2 = new byte[]{2, 3, 4, 5, 6};
        TestBytes.assertTrue((boolean)Arrays.equals(expected2, actual2));
        TestBytes.assertEquals((int)0, (int)target2.position());
        TestBytes.assertEquals((int)5, (int)target2.limit());
    }

    public void testGetBytesForByteBuffer() {
        byte[] array = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteBuffer target = ByteBuffer.wrap(array);
        target.position(2);
        target.limit(7);
        byte[] actual = Bytes.getBytes((ByteBuffer)target);
        byte[] expected = new byte[]{2, 3, 4, 5, 6};
        TestBytes.assertTrue((boolean)Arrays.equals(expected, actual));
        TestBytes.assertEquals((int)2, (int)target.position());
        TestBytes.assertEquals((int)7, (int)target.limit());
    }

    public void testReadAsVLong() throws Exception {
        long[] longs = new long[]{-1L, 123L, Long.MIN_VALUE, Long.MAX_VALUE};
        for (int i = 0; i < longs.length; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(baos);
            WritableUtils.writeVLong((DataOutput)output, (long)longs[i]);
            byte[] long_bytes_no_offset = baos.toByteArray();
            TestBytes.assertEquals((long)longs[i], (long)Bytes.readAsVLong((byte[])long_bytes_no_offset, (int)0));
            byte[] long_bytes_with_offset = this.bytesWithOffset(long_bytes_no_offset);
            TestBytes.assertEquals((long)longs[i], (long)Bytes.readAsVLong((byte[])long_bytes_with_offset, (int)1));
        }
    }

    public void testToStringBinaryForBytes() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        String actual = Bytes.toStringBinary((byte[])array);
        String expected = "09azAZ@\\x01";
        TestBytes.assertEquals((String)expected, (String)actual);
        String actual2 = Bytes.toStringBinary((byte[])array, (int)2, (int)3);
        String expected2 = "azA";
        TestBytes.assertEquals((String)expected2, (String)actual2);
    }

    public void testToStringBinaryForArrayBasedByteBuffer() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        ByteBuffer target = ByteBuffer.wrap(array);
        String actual = Bytes.toStringBinary((ByteBuffer)target);
        String expected = "09azAZ@\\x01";
        TestBytes.assertEquals((String)expected, (String)actual);
    }

    public void testToStringBinaryForReadOnlyByteBuffer() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        ByteBuffer target = ByteBuffer.wrap(array).asReadOnlyBuffer();
        String actual = Bytes.toStringBinary((ByteBuffer)target);
        String expected = "09azAZ@\\x01";
        TestBytes.assertEquals((String)expected, (String)actual);
    }

    public void testBinarySearch() throws Exception {
        byte[][] arr = new byte[][]{{1}, {3}, {5}, {7}, {9}, {11}, {13}, {15}};
        byte[] key1 = new byte[]{3, 1};
        byte[] key2 = new byte[]{4, 9};
        byte[] key2_2 = new byte[]{4};
        byte[] key3 = new byte[]{5, 11};
        byte[] key4 = new byte[]{0};
        byte[] key5 = new byte[]{2};
        TestBytes.assertEquals((int)1, (int)Bytes.binarySearch((byte[][])arr, (byte[])key1, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)0, (int)Bytes.binarySearch((byte[][])arr, (byte[])key1, (int)1, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)-3, (int)Arrays.binarySearch(arr, key2_2, Bytes.BYTES_COMPARATOR));
        TestBytes.assertEquals((int)-3, (int)Bytes.binarySearch((byte[][])arr, (byte[])key2, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)4, (int)Bytes.binarySearch((byte[][])arr, (byte[])key2, (int)1, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)2, (int)Bytes.binarySearch((byte[][])arr, (byte[])key3, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)5, (int)Bytes.binarySearch((byte[][])arr, (byte[])key3, (int)1, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)-1, (int)Bytes.binarySearch((byte[][])arr, (byte[])key4, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)-2, (int)Bytes.binarySearch((byte[][])arr, (byte[])key5, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        for (int i = 0; i < arr.length; ++i) {
            TestBytes.assertEquals((int)(-(i + 1)), (int)Bytes.binarySearch((byte[][])arr, (byte[])new byte[]{(byte)(arr[i][0] - 1)}, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
            TestBytes.assertEquals((int)(-(i + 2)), (int)Bytes.binarySearch((byte[][])arr, (byte[])new byte[]{(byte)(arr[i][0] + 1)}, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        }
    }

    public void testToStringBytesBinaryReversible() {
        Random rand = new Random(System.currentTimeMillis());
        byte[] randomBytes = new byte[1000];
        for (int i = 0; i < 1000; ++i) {
            rand.nextBytes(randomBytes);
            this.verifyReversibleForBytes(randomBytes);
        }
        this.verifyReversibleForBytes(new byte[0]);
        this.verifyReversibleForBytes(new byte[]{92, 120, 65, 68});
        this.verifyReversibleForBytes(new byte[]{92, 120, 65, 68, 92});
    }

    private void verifyReversibleForBytes(byte[] originalBytes) {
        String convertedString = Bytes.toStringBinary((byte[])originalBytes);
        byte[] convertedBytes = Bytes.toBytesBinary((String)convertedString);
        if (Bytes.compareTo((byte[])originalBytes, (byte[])convertedBytes) != 0) {
            TestBytes.fail((String)("Not reversible for\nbyte[]: " + Arrays.toString(originalBytes) + ",\nStringBinary: " + convertedString));
        }
    }

    public void testStartsWith() {
        TestBytes.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"h")));
        TestBytes.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"")));
        TestBytes.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"hello")));
        TestBytes.assertFalse((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"helloworld")));
        TestBytes.assertFalse((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)""), (byte[])Bytes.toBytes((String)"hello")));
    }

    public void testIncrementBytes() throws IOException {
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(12L, 123435445L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(124634654L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10005460L, 5005645L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1L, -1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1005435000L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -43657655L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-26L, 5034520L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10657200L, 5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, 45376475L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12L, -34565445L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1546543452L, -34565445L));
    }

    private static boolean checkTestIncrementBytes(long val, long amount) throws IOException {
        byte[] value = Bytes.toBytes((long)val);
        byte[] testValue = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        if (value[0] > 0) {
            testValue = new byte[8];
        }
        System.arraycopy(value, 0, testValue, testValue.length - value.length, value.length);
        long incrementResult = Bytes.toLong((byte[])Bytes.incrementBytes((byte[])value, (long)amount));
        return Bytes.toLong((byte[])testValue) + amount == incrementResult;
    }

    public void testFixedSizeString() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"Hello", (int)5);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"World", (int)18);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"", (int)9);
        try {
            Bytes.writeStringFixedSize((DataOutput)dos, (String)"Too\u2013Long", (int)9);
            TestBytes.fail((String)"Exception expected");
        }
        catch (IOException ex) {
            TestBytes.assertEquals((String)"Trying to write 10 bytes (Too\\xE2\\x80\\x93Long) into a field of length 9", (String)ex.getMessage());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        TestBytes.assertEquals((String)"Hello", (String)Bytes.readStringFixedSize((DataInput)dis, (int)5));
        TestBytes.assertEquals((String)"World", (String)Bytes.readStringFixedSize((DataInput)dis, (int)18));
        TestBytes.assertEquals((String)"", (String)Bytes.readStringFixedSize((DataInput)dis, (int)9));
    }

    public void testCopy() throws Exception {
        byte[] copy;
        byte[] bytes = Bytes.toBytes((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        TestBytes.assertFalse((bytes == (copy = Bytes.copy((byte[])bytes)) ? 1 : 0) != 0);
        TestBytes.assertTrue((boolean)Bytes.equals((byte[])bytes, (byte[])copy));
    }

    public void testToBytesBinaryTrailingBackslashes() throws Exception {
        try {
            Bytes.toBytesBinary((String)"abc\\x00\\x01\\");
        }
        catch (StringIndexOutOfBoundsException ex) {
            TestBytes.fail((String)("Illegal string access: " + ex.getMessage()));
        }
    }

    public void testToStringBinary_toBytesBinary_Reversable() throws Exception {
        String bytes = Bytes.toStringBinary((byte[])Bytes.toBytes((double)2.17));
        TestBytes.assertEquals((double)2.17, (double)Bytes.toDouble((byte[])Bytes.toBytesBinary((String)bytes)), (double)0.0);
    }

    public void testUnsignedBinarySearch() {
        byte[] bytes = new byte[]{0, 5, 123, 127, -128, -100, -1};
        Assert.assertEquals((long)1L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)5));
        Assert.assertEquals((long)3L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)127));
        Assert.assertEquals((long)4L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-128));
        Assert.assertEquals((long)5L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-100));
        Assert.assertEquals((long)6L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-1));
        Assert.assertEquals((long)-2L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)2));
        Assert.assertEquals((long)-7L, (long)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-5));
    }

    public void testUnsignedIncrement() {
        byte[] a = Bytes.toBytes((int)0);
        int a2 = Bytes.toInt((byte[])Bytes.unsignedCopyAndIncrement((byte[])a), (int)0);
        Assert.assertTrue((a2 == 1 ? 1 : 0) != 0);
        byte[] b = Bytes.toBytes((int)-1);
        byte[] actual = Bytes.unsignedCopyAndIncrement((byte[])b);
        Assert.assertNotSame((Object)b, (Object)actual);
        byte[] expected = new byte[]{1, 0, 0, 0, 0};
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        byte[] c = Bytes.toBytes((int)255);
        int c2 = Bytes.toInt((byte[])Bytes.unsignedCopyAndIncrement((byte[])c), (int)0);
        Assert.assertTrue((c2 == 256 ? 1 : 0) != 0);
    }

    public void testIndexOf() {
        byte[] array = Bytes.toBytes((String)"hello");
        TestBytes.assertEquals((int)1, (int)Bytes.indexOf((byte[])array, (byte)101));
        TestBytes.assertEquals((int)4, (int)Bytes.indexOf((byte[])array, (byte)111));
        TestBytes.assertEquals((int)-1, (int)Bytes.indexOf((byte[])array, (byte)97));
        TestBytes.assertEquals((int)0, (int)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"hel")));
        TestBytes.assertEquals((int)2, (int)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"ll")));
        TestBytes.assertEquals((int)-1, (int)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"hll")));
    }

    public void testContains() {
        byte[] array = Bytes.toBytes((String)"hello world");
        TestBytes.assertTrue((boolean)Bytes.contains((byte[])array, (byte)101));
        TestBytes.assertTrue((boolean)Bytes.contains((byte[])array, (byte)100));
        TestBytes.assertFalse((boolean)Bytes.contains((byte[])array, (byte)97));
        TestBytes.assertTrue((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"world")));
        TestBytes.assertTrue((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"ello")));
        TestBytes.assertFalse((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"owo")));
    }

    public void testZero() {
        int i;
        byte[] array = Bytes.toBytes((String)"hello");
        Bytes.zero((byte[])array);
        for (i = 0; i < array.length; ++i) {
            TestBytes.assertEquals((int)0, (int)array[i]);
        }
        array = Bytes.toBytes((String)"hello world");
        Bytes.zero((byte[])array, (int)2, (int)7);
        TestBytes.assertFalse((array[0] == 0 ? 1 : 0) != 0);
        TestBytes.assertFalse((array[1] == 0 ? 1 : 0) != 0);
        for (i = 2; i < 9; ++i) {
            TestBytes.assertEquals((int)0, (int)array[i]);
        }
        for (i = 9; i < array.length; ++i) {
            TestBytes.assertFalse((array[i] == 0 ? 1 : 0) != 0);
        }
    }

    public void testPutBuffer() {
        byte i;
        byte[] b = new byte[100];
        for (i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            Bytes.putByteBuffer((byte[])b, (int)i, (ByteBuffer)ByteBuffer.wrap(new byte[]{i}));
        }
        for (i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            Assert.assertEquals((long)i, (long)b[i]);
        }
    }

    public void testToFromHex() {
        ArrayList<String> testStrings = new ArrayList<String>();
        testStrings.addAll(Arrays.asList("", "00", "A0", "ff", "FFffFFFFFFFFFF", "12", "0123456789abcdef", "283462839463924623984692834692346ABCDFEDDCA0"));
        for (String testString : testStrings) {
            byte[] byteData = Bytes.fromHex((String)testString);
            Assert.assertEquals((long)(testString.length() / 2), (long)byteData.length);
            String string = Bytes.toHex((byte[])byteData);
            Assert.assertTrue((boolean)testString.equalsIgnoreCase(string));
        }
        ArrayList<Object> testByteData = new ArrayList<Object>();
        testByteData.addAll(Arrays.asList(new byte[0], new byte[1], new byte[10], {1, 2, 3, 4, 5}, {-1}));
        Random r = new Random();
        for (int i = 0; i < 20; ++i) {
            byte[] byArray = new byte[r.nextInt(100)];
            r.nextBytes(byArray);
            testByteData.add(byArray);
        }
        for (byte[] byArray : testByteData) {
            String hexString = Bytes.toHex((byte[])byArray);
            Assert.assertEquals((long)(byArray.length * 2), (long)hexString.length());
            byte[] result = Bytes.fromHex((String)hexString);
            Assert.assertArrayEquals((byte[])byArray, (byte[])result);
        }
    }
}

