/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.mapr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestBufferedMutatorExample
extends Configured
implements Tool {
    private static final byte[] CF1 = Bytes.toBytes((String)"cf1");
    private static final byte[] CF2 = Bytes.toBytes((String)"cf2");
    private static final Log LOG = LogFactory.getLog(TestBufferedMutatorExample.class);
    private static final int POOL_SIZE = 10;
    private static final int TASK_COUNT = 100;
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");

    public int run(String[] argv) throws InterruptedException, ExecutionException, TimeoutException {
        if (argv.length < 1) {
            System.out.println("Test the table operations with HBase 1.1 style. Usage:\nTo test in MapR DB\n\t hbase org.apache.hadoop.hbase.client.TestBufferedMutatorExample tableName MapRDB\nTo test in HBase\n\t hbase org.apache.hadoop.hbase.client.TestBufferedMutatorExample tableName HBbase");
            return -1;
        }
        TableName tableName = TableName.valueOf((String)argv[0]);
        Configuration conf = HBaseConfiguration.create();
        String defaultdb = conf.get("mapr.hbase.default.db");
        if (argv.length > 1) {
            defaultdb = argv[1];
            conf.set("mapr.hbase.default.db", defaultdb);
            System.out.println("-----Set DB " + defaultdb + "-----");
        }
        BufferedMutator.ExceptionListener listener = new BufferedMutator.ExceptionListener(){

            public void onException(RetriesExhaustedWithDetailsException e, BufferedMutator mutator) {
                for (int i = 0; i < e.getNumExceptions(); ++i) {
                    Row row = e.getRow(i);
                    LOG.info((Object)("Failed to sent put " + i + ":" + row + "."));
                }
            }
        };
        BufferedMutatorParams params = new BufferedMutatorParams(tableName).listener(listener);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             BufferedMutator mutator = conn.getBufferedMutator(params);){
            ExecutorService workerPool = Executors.newFixedThreadPool(10);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(100);
            for (int i = 0; i < 100; ++i) {
                futures.add(workerPool.submit(new SinglePut(i, mutator)));
            }
            for (Future future : futures) {
                future.get(5L, TimeUnit.MINUTES);
            }
            workerPool.shutdown();
            LOG.info((Object)"WorkerPool shutdown successfully");
            mutator.close();
            LOG.info((Object)"Mutator close successfully");
            conn.close();
            LOG.info((Object)"Connection close successfully");
        }
        catch (IOException e) {
            LOG.info((Object)"exception while creating/destroying Connection or BufferedMutator");
            e.printStackTrace();
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new TestBufferedMutatorExample(), (String[])args);
    }

    public static class SinglePut
    implements Callable<Void> {
        private int rowid;
        private BufferedMutator mutator;

        public SinglePut(int rowid, BufferedMutator mutator) {
            this.rowid = rowid;
            this.mutator = mutator;
        }

        @Override
        public Void call() throws Exception {
            this.putarow(this.rowid);
            return null;
        }

        private void putarow(int n) throws Exception {
            Put p = new Put(Bytes.toBytes((String)("Row" + n)));
            p.addColumn(CF1, Bytes.toBytes((String)"qual1"), Bytes.toBytes((String)"value1"));
            this.mutator.mutate((Mutation)p);
            this.mutator.flush();
        }
    }
}

