/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.mapr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestAutoFlushFalse
extends Configured
implements Tool {
    private static final byte[] CF1 = Bytes.toBytes((String)"cf1");
    private static final byte[] CF2 = Bytes.toBytes((String)"cf2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] argv) throws IOException {
        if (argv.length < 1) {
            System.out.println("Test the table operations with HBase 1.1 style. Usage:\nTo test in MapR DB\n\t hbase org.apache.hadoop.hbase.client.TestBufferedMutator tableName MapRDB\nTo test in HBase\n\t hbase org.apache.hadoop.hbase.client.TestBufferedMutator tableName HBbase");
            return -1;
        }
        TableName tableName = TableName.valueOf((String)argv[0]);
        Configuration conf = HBaseConfiguration.create();
        String defaultdb = conf.get("mapr.hbase.default.db");
        if (argv.length > 1) {
            defaultdb = argv[1];
            conf.set("mapr.hbase.default.db", defaultdb);
            System.out.println("-----Set DB " + defaultdb + "-----");
        }
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = null;
        admin = conn.getAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd1 = new HColumnDescriptor(CF1);
        HColumnDescriptor hcd2 = new HColumnDescriptor(CF2);
        tableDesc.addFamily(hcd1);
        tableDesc.addFamily(hcd2);
        admin.createTable(tableDesc);
        HTable table = new HTable(conf, tableName);
        try {
            Put p = new Put(Bytes.toBytes((String)"row1"));
            p.addColumn(CF1, Bytes.toBytes((String)"col1"), Bytes.toBytes((String)"val11"));
            p.addColumn(CF2, Bytes.toBytes((String)"col2"), Bytes.toBytes((String)"val12"));
            table.setAutoFlush(false);
            table.put(p);
            Get g = new Get(Bytes.toBytes((String)"row1"));
            g.addColumn(CF1, Bytes.toBytes((String)"col1"));
            Result result = table.get(g);
            System.out.println("Result: " + result.size());
            if (result.size() > 0) {
                for (KeyValue keyValue : result.list()) {
                    System.out.println("Qualifier : " + keyValue.getKeyString() + " : Value : " + Bytes.toString((byte[])keyValue.getValue()));
                }
                System.out.println("Error: Autoflush is false, but data reaches the table!");
                int n = -1;
                return n;
            }
            table.flushCommits();
            Result result2 = table.get(g);
            System.out.println("Result: " + result2.size());
            if (result2.size() <= 0) {
                System.out.println("Error: called flush, but data is NOT in the table!");
                int keyValue = -2;
                return keyValue;
            }
            for (KeyValue keyValue : result2.list()) {
                System.out.println("Qualifier : " + keyValue.getKeyString() + " : Value : " + Bytes.toString((byte[])keyValue.getValue()));
            }
            if (result2.size() != 1) {
                System.out.println("Error: called flush, but data size is not 1 in the table!");
                int keyValue = -3;
                return keyValue;
            }
            Delete d = new Delete(Bytes.toBytes((String)"row1"));
            d.addFamily(CF1);
            table.delete(d);
            g = new Get(Bytes.toBytes((String)"row1"));
            g.addFamily(CF1);
            Result result3 = table.get(g);
            System.out.println("After delete Result: " + result3.size());
        }
        finally {
            table.close();
            conn.close();
        }
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int ret = ToolRunner.run((Tool)new TestAutoFlushFalse(), (String[])argv);
        System.exit(ret);
    }
}

