/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.CompleteScanResultCache;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestCompleteResultScanResultCache {
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ1 = Bytes.toBytes((String)"cq1");
    private static byte[] CQ2 = Bytes.toBytes((String)"cq2");
    private static byte[] CQ3 = Bytes.toBytes((String)"cq3");
    private CompleteScanResultCache resultCache;
    private final LinkedList<Result> cache = new LinkedList();

    @Before
    public void setUp() {
        this.resultCache = new CompleteScanResultCache(this.cache);
    }

    @After
    public void tearDown() {
        this.resultCache.clear();
        this.resultCache = null;
    }

    private static Cell createCell(int key, byte[] cq) {
        return new KeyValue(Bytes.toBytes((int)key), CF, cq, Bytes.toBytes((int)key));
    }

    @Test
    public void testNoPartial() throws IOException {
        int i;
        this.cache.clear();
        this.resultCache.loadResultsToCache(ScanResultCache.EMPTY_RESULT_ARRAY, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(ScanResultCache.EMPTY_RESULT_ARRAY, true);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        int count = 10;
        Result[] results = new Result[count];
        for (i = 0; i < count; ++i) {
            results[i] = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(i, CQ1)));
        }
        this.resultCache.loadResultsToCache(results, false);
        results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)count, (long)results.length);
        for (i = 0; i < count; ++i) {
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])results[i].getRow()));
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])results[i].getValue(CF, CQ1)));
        }
    }

    @Test
    public void testCombine1() throws IOException {
        this.cache.clear();
        Result previousResult = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(0, CQ1)), null, (boolean)false, (boolean)true);
        Result result1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ1)), null, (boolean)false, (boolean)true);
        Result result2 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ2)), null, (boolean)false, (boolean)true);
        Result result3 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ3)), null, (boolean)false, (boolean)true);
        this.resultCache.loadResultsToCache(new Result[]{previousResult, result1}, false);
        Result[] results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertSame((Object)previousResult, (Object)results[0]);
        this.cache.clear();
        this.resultCache.loadResultsToCache(new Result[]{result2}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[]{result3}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[0], true);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[0], false);
        results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getRow()));
        Assert.assertEquals((long)3L, (long)results[0].rawCells().length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ1)));
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ2)));
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ3)));
    }

    @Test
    public void testCombine2() throws IOException {
        this.cache.clear();
        Result result1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ1)), null, (boolean)false, (boolean)true);
        Result result2 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ2)), null, (boolean)false, (boolean)true);
        Result result3 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ3)), null, (boolean)false, (boolean)true);
        Result nextResult1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(2, CQ1)), null, (boolean)false, (boolean)true);
        Result nextToNextResult1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(3, CQ2)), null, (boolean)false, (boolean)false);
        this.resultCache.loadResultsToCache(new Result[]{result1}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[]{result2}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[]{result3}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[]{nextResult1}, false);
        Result[] results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getRow()));
        Assert.assertEquals((long)3L, (long)results[0].rawCells().length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ1)));
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ2)));
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ3)));
        this.cache.clear();
        this.resultCache.loadResultsToCache(new Result[]{nextToNextResult1}, false);
        results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results[0].getRow()));
        Assert.assertEquals((long)1L, (long)results[0].rawCells().length);
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ1)));
        Assert.assertEquals((long)3L, (long)Bytes.toInt((byte[])results[1].getRow()));
        Assert.assertEquals((long)1L, (long)results[1].rawCells().length);
        Assert.assertEquals((long)3L, (long)Bytes.toInt((byte[])results[1].getValue(CF, CQ2)));
    }

    @Test
    public void testCombine3() throws IOException {
        this.cache.clear();
        Result result1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ1)), null, (boolean)false, (boolean)true);
        Result result2 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ2)), null, (boolean)false, (boolean)true);
        Result nextResult1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(2, CQ1)), null, (boolean)false, (boolean)false);
        Result nextToNextResult1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(3, CQ1)), null, (boolean)false, (boolean)true);
        this.resultCache.loadResultsToCache(new Result[]{result1}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[]{result2}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[]{nextResult1, nextToNextResult1}, false);
        Result[] results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getRow()));
        Assert.assertEquals((long)2L, (long)results[0].rawCells().length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ1)));
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ2)));
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results[1].getRow()));
        Assert.assertEquals((long)1L, (long)results[1].rawCells().length);
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results[1].getValue(CF, CQ1)));
        this.cache.clear();
        this.resultCache.loadResultsToCache(new Result[0], false);
        results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((long)3L, (long)Bytes.toInt((byte[])results[0].getRow()));
        Assert.assertEquals((long)1L, (long)results[0].rawCells().length);
        Assert.assertEquals((long)3L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ1)));
    }

    @Test
    public void testCombine4() throws IOException {
        this.cache.clear();
        Result result1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ1)), null, (boolean)false, (boolean)true);
        Result result2 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(1, CQ2)), null, (boolean)false, (boolean)false);
        Result nextResult1 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(2, CQ1)), null, (boolean)false, (boolean)true);
        Result nextResult2 = Result.create(Arrays.asList(TestCompleteResultScanResultCache.createCell(2, CQ2)), null, (boolean)false, (boolean)false);
        this.resultCache.loadResultsToCache(new Result[]{result1}, false);
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.resultCache.loadResultsToCache(new Result[]{result2, nextResult1}, false);
        Result[] results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getRow()));
        Assert.assertEquals((long)2L, (long)results[0].rawCells().length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ1)));
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ2)));
        this.cache.clear();
        this.resultCache.loadResultsToCache(new Result[]{nextResult2}, false);
        results = this.cache.toArray(new Result[0]);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results[0].getRow()));
        Assert.assertEquals((long)2L, (long)results[0].rawCells().length);
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ1)));
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results[0].getValue(CF, CQ2)));
    }
}

