/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDeleteTimeStamp {
    private static final byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");

    @Test
    public void testTimeStamp() {
        long ts = 2014L;
        Delete delete = new Delete(ROW);
        delete.setTimestamp(ts);
        delete.deleteColumn(FAMILY, QUALIFIER);
        NavigableMap familyCellmap = delete.getFamilyCellMap();
        for (Map.Entry entry : familyCellmap.entrySet()) {
            for (Cell cell : (List)entry.getValue()) {
                Assert.assertEquals((long)ts, (long)cell.getTimestamp());
            }
        }
    }
}

