/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestHTableMultiplexerViaMocks {
    private HTableMultiplexer mockMultiplexer;
    private ClusterConnection mockConnection;

    @Before
    public void setupTest() {
        this.mockMultiplexer = (HTableMultiplexer)Mockito.mock(HTableMultiplexer.class);
        this.mockConnection = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        Mockito.when((Object)this.mockMultiplexer.put((TableName)Matchers.any(TableName.class), (Put)Matchers.any(Put.class), Matchers.anyInt())).thenCallRealMethod();
        Mockito.when((Object)this.mockMultiplexer.getConnection()).thenReturn((Object)this.mockConnection);
    }

    @Test
    public void testConnectionClosing() throws IOException {
        ((HTableMultiplexer)Mockito.doCallRealMethod().when((Object)this.mockMultiplexer)).close();
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        this.mockMultiplexer.close();
        ((ClusterConnection)Mockito.verify((Object)this.mockConnection)).close();
    }

    @Test
    public void testClosingAlreadyClosedConnection() throws IOException {
        ((HTableMultiplexer)Mockito.doCallRealMethod().when((Object)this.mockMultiplexer)).close();
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)true);
        this.mockMultiplexer.close();
        ((ClusterConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)0))).close();
    }
}

