/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.backoff.ExponentialClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestClientExponentialBackoff {
    ServerName server = (ServerName)Mockito.mock(ServerName.class);
    byte[] regionname = Bytes.toBytes((String)"region");

    @Test
    public void testNulls() {
        Configuration conf = new Configuration(false);
        ExponentialClientBackoffPolicy backoff = new ExponentialClientBackoffPolicy(conf);
        Assert.assertEquals((long)0L, (long)backoff.getBackoffTime(null, null, null));
        Assert.assertEquals((long)0L, (long)backoff.getBackoffTime(this.server, null, null));
        Assert.assertEquals((long)0L, (long)backoff.getBackoffTime(this.server, this.regionname, null));
        ServerStatistics stats = new ServerStatistics();
        Assert.assertEquals((long)0L, (long)backoff.getBackoffTime(this.server, this.regionname, stats));
    }

    @Test
    public void testMaxLoad() {
        Configuration conf = new Configuration(false);
        ExponentialClientBackoffPolicy backoff = new ExponentialClientBackoffPolicy(conf);
        ServerStatistics stats = new ServerStatistics();
        this.update(stats, 100);
        Assert.assertEquals((long)300000L, (long)backoff.getBackoffTime(this.server, this.regionname, stats));
        long max = 100L;
        conf.setLong("hbase.client.exponential-backoff.max", max);
        ExponentialClientBackoffPolicy backoffShortTimeout = new ExponentialClientBackoffPolicy(conf);
        Assert.assertEquals((long)max, (long)backoffShortTimeout.getBackoffTime(this.server, this.regionname, stats));
        this.update(stats, 101);
        Assert.assertEquals((long)300000L, (long)backoff.getBackoffTime(this.server, this.regionname, stats));
        Assert.assertEquals((long)max, (long)backoffShortTimeout.getBackoffTime(this.server, this.regionname, stats));
        this.update(stats, 99);
        Assert.assertTrue((backoff.getBackoffTime(this.server, this.regionname, stats) < 300000L ? 1 : 0) != 0);
        Assert.assertTrue((backoffShortTimeout.getBackoffTime(this.server, this.regionname, stats) < max ? 1 : 0) != 0);
    }

    @Test
    public void testResultOrdering() {
        Configuration conf = new Configuration(false);
        conf.setLong("hbase.client.exponential-backoff.max", Integer.MAX_VALUE);
        ExponentialClientBackoffPolicy backoff = new ExponentialClientBackoffPolicy(conf);
        ServerStatistics stats = new ServerStatistics();
        long previous = backoff.getBackoffTime(this.server, this.regionname, stats);
        for (int i = 1; i <= 100; ++i) {
            this.update(stats, i);
            long next = backoff.getBackoffTime(this.server, this.regionname, stats);
            Assert.assertTrue((String)("Previous backoff time" + previous + " >= " + next + ", the next backoff time for load " + i), (previous < next ? 1 : 0) != 0);
            previous = next;
        }
    }

    @Test
    public void testHeapOccupancyPolicy() {
        Configuration conf = new Configuration(false);
        ExponentialClientBackoffPolicy backoff = new ExponentialClientBackoffPolicy(conf);
        ServerStatistics stats = new ServerStatistics();
        this.update(stats, 0, 95, 0);
        long backoffTime = backoff.getBackoffTime(this.server, this.regionname, stats);
        Assert.assertTrue((String)"Heap occupancy at low watermark had no effect", (backoffTime > 0L ? 1 : 0) != 0);
        long previous = backoffTime;
        this.update(stats, 0, 96, 0);
        backoffTime = backoff.getBackoffTime(this.server, this.regionname, stats);
        Assert.assertTrue((String)"Increase above low watermark should have increased backoff", (backoffTime > previous ? 1 : 0) != 0);
        this.update(stats, 0, 98, 0);
        backoffTime = backoff.getBackoffTime(this.server, this.regionname, stats);
        Assert.assertEquals((String)"We should be using max backoff when at high watermark", (long)300000L, (long)backoffTime);
    }

    @Test
    public void testCompactionPressurePolicy() {
        Configuration conf = new Configuration(false);
        ExponentialClientBackoffPolicy backoff = new ExponentialClientBackoffPolicy(conf);
        ServerStatistics stats = new ServerStatistics();
        this.update(stats, 0, 0, 0);
        long backoffTime = backoff.getBackoffTime(this.server, this.regionname, stats);
        Assert.assertTrue((String)"Compaction pressure has no effect", (backoffTime == 0L ? 1 : 0) != 0);
        long previous = backoffTime;
        this.update(stats, 0, 0, 50);
        backoffTime = backoff.getBackoffTime(this.server, this.regionname, stats);
        Assert.assertTrue((String)"Compaction pressure should be bigger", (backoffTime > previous ? 1 : 0) != 0);
        this.update(stats, 0, 0, 100);
        backoffTime = backoff.getBackoffTime(this.server, this.regionname, stats);
        Assert.assertEquals((String)"under heavy compaction pressure", (long)300000L, (long)backoffTime);
    }

    private void update(ServerStatistics stats, int load) {
        ClientProtos.RegionLoadStats stat = ClientProtos.RegionLoadStats.newBuilder().setMemstoreLoad(load).build();
        stats.update(this.regionname, stat);
    }

    private void update(ServerStatistics stats, int memstoreLoad, int heapOccupancy, int compactionPressure) {
        ClientProtos.RegionLoadStats stat = ClientProtos.RegionLoadStats.newBuilder().setMemstoreLoad(memstoreLoad).setHeapOccupancy(heapOccupancy).setCompactionPressure(compactionPressure).build();
        stats.update(this.regionname, stat);
    }
}

