/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;

public class ServiceClientTest
extends ServiceClient {
    private Configuration conf = new Configuration();
    private Service goodServiceStatus = ServiceClientTest.buildLiveGoodService();
    private boolean initialized;
    private Set<String> expectedInstances = new HashSet<String>();
    private Map<String, ApplicationId> serviceAppId = new HashMap<String, ApplicationId>();

    public void init(Configuration conf) {
        if (!this.initialized) {
            super.init(conf);
            this.initialized = true;
        }
    }

    public void stop() {
    }

    public void forceStop() {
        this.expectedInstances.clear();
        this.stop();
    }

    public Configuration getConfig() {
        return this.conf;
    }

    public ApplicationId actionCreate(Service service) throws IOException {
        ServiceApiUtil.validateAndResolveService((Service)service, (SliderFileSystem)new SliderFileSystem(this.conf), (Configuration)this.getConfig());
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        this.serviceAppId.put(service.getName(), appId);
        return appId;
    }

    public Service getStatus(String appName) throws FileNotFoundException {
        if ("jenkins".equals(appName)) {
            return this.goodServiceStatus;
        }
        throw new FileNotFoundException("Service " + appName + " not found");
    }

    public ApplicationId actionStartAndGetId(String serviceName) throws YarnException, IOException {
        if (serviceName != null && serviceName.equals("jenkins")) {
            ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
            this.serviceAppId.put(serviceName, appId);
            return appId;
        }
        throw new ApplicationNotFoundException("");
    }

    public int actionStop(String serviceName, boolean waitForAppStopped) throws YarnException, IOException {
        if (serviceName == null) {
            throw new NullPointerException();
        }
        if (serviceName.equals("jenkins")) {
            return 0;
        }
        if (serviceName.equals("jenkins-second-stop")) {
            return 40;
        }
        throw new ApplicationNotFoundException("");
    }

    public int actionDestroy(String serviceName) {
        if (serviceName != null) {
            if (serviceName.equals("jenkins")) {
                return 0;
            }
            if (serviceName.equals("jenkins-already-stopped")) {
                return 0;
            }
            if (serviceName.equals("jenkins-doesn't-exist")) {
                return 44;
            }
            if (serviceName.equals("jenkins-error-cleaning-registry")) {
                return 5;
            }
        }
        throw new IllegalArgumentException();
    }

    public int initiateUpgrade(Service service) throws YarnException, IOException {
        if (service.getName() != null && service.getName().equals("jenkins")) {
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public int actionUpgrade(Service service, List<Container> compInstances) throws IOException, YarnException {
        Set actualInstances;
        if (service.getName() != null && service.getName().equals("jenkins") && compInstances != null && (actualInstances = compInstances.stream().map(Container::getComponentInstanceName).collect(Collectors.toSet())).equals(this.expectedInstances)) {
            return 0;
        }
        throw new IllegalArgumentException();
    }

    Service getGoodServiceStatus() {
        return this.goodServiceStatus;
    }

    void setExpectedInstances(Set<String> instances) {
        if (instances != null) {
            this.expectedInstances.addAll(instances);
        }
    }

    static Service buildGoodService() {
        Service service = new Service();
        service.setName("jenkins");
        service.setVersion("v1");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < 2; ++i) {
            Component c = new Component();
            c.setName("jenkins" + i);
            c.setNumberOfContainers(Long.valueOf(2L));
            c.setArtifact(artifact);
            c.setLaunchCommand("");
            c.setResource(resource);
            components.add(c);
        }
        service.setComponents(components);
        return service;
    }

    static Service buildLiveGoodService() {
        Service service = ServiceClientTest.buildGoodService();
        Component comp = (Component)service.getComponents().iterator().next();
        ArrayList<Container> containers = new ArrayList<Container>();
        int i = 0;
        while ((long)i < comp.getNumberOfContainers()) {
            Container container = new Container();
            container.setComponentInstanceName(comp.getName() + "-" + (i + 1));
            container.setState(ContainerState.READY);
            containers.add(container);
            ++i;
        }
        comp.setContainers(containers);
        return service;
    }

    public synchronized ApplicationId getAppId(String serviceName) throws IOException, YarnException {
        return this.serviceAppId.get(serviceName);
    }
}

