/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.webproxy.FedAppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWebAppProxyServletFed {
    private static final Logger LOG = LoggerFactory.getLogger(TestWebAppProxyServletFed.class);
    public static final String AM_PREFIX = "AM";
    public static final String RM_PREFIX = "RM";
    public static final String AHS_PREFIX = "AHS";
    private static Server mockServer;
    private static int mockServerPort;

    @BeforeClass
    public static void setUp() throws Exception {
        mockServer = new Server(0);
        ((QueuedThreadPool)mockServer.getThreadPool()).setMaxThreads(20);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.addServlet(new ServletHolder((Servlet)new MockWebServlet(AM_PREFIX)), "/amweb/*");
        context.addServlet(new ServletHolder((Servlet)new MockWebServlet(RM_PREFIX)), "/cluster/app/*");
        context.addServlet(new ServletHolder((Servlet)new MockWebServlet(AHS_PREFIX)), "/applicationhistory/app/*");
        mockServer.setHandler((Handler)context);
        ((ServerConnector)mockServer.getConnectors()[0]).setHost("localhost");
        mockServer.start();
        mockServerPort = ((ServerConnector)mockServer.getConnectors()[0]).getLocalPort();
        LOG.info("Running embedded servlet container at: http://localhost:" + mockServerPort);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (mockServer != null) {
            mockServer.stop();
            mockServer.destroy();
            mockServer = null;
        }
    }

    @Test
    public void testWebServlet() throws IOException {
        URL url = new URL("http", "localhost", mockServerPort, "/amweb/apptest");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)"AM/apptest", (Object)this.readResponse(conn));
        conn.disconnect();
        url = new URL("http", "localhost", mockServerPort, "/cluster/app/apptest");
        conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)"RM/apptest", (Object)this.readResponse(conn));
        conn.disconnect();
        url = new URL("http", "localhost", mockServerPort, "/applicationhistory/app/apptest");
        conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)"AHS/apptest", (Object)this.readResponse(conn));
        conn.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testWebAppProxyServletFed() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.web-proxy.address", "localhost:9090");
        conf.setBoolean("yarn.federation.enabled", true);
        conf.setBoolean("yarn.timeline-service.generic-application-history.enabled", true);
        conf.set("yarn.timeline-service.webapp.address", "localhost:" + mockServerPort);
        conf.setInt("hadoop.http.max.threads", 10);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"scid1");
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"scid2");
        SubClusterInfo subClusterInfo1 = SubClusterInfo.newInstance((SubClusterId)subClusterId1, (String)"10.0.0.1:1", (String)"10.0.0.1:1", (String)"10.0.0.1:1", (String)("localhost:" + mockServerPort), (SubClusterState)SubClusterState.SC_RUNNING, (long)0L, (String)"");
        SubClusterInfo subClusterInfo2 = SubClusterInfo.newInstance((SubClusterId)subClusterId2, (String)"10.0.0.2:1", (String)"10.0.0.2:1", (String)"10.0.0.2:1", (String)"10.0.0.2:1", (SubClusterState)SubClusterState.SC_RUNNING, (long)0L, (String)"");
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationId appId2 = ApplicationId.newInstance((long)0L, (int)2);
        String appUrl1 = "http://localhost:" + mockServerPort + "/amweb/" + appId1;
        String appUrl2 = "http://localhost:" + mockServerPort + "/amweb/" + appId2;
        ApplicationId appId3 = ApplicationId.newInstance((long)0L, (int)3);
        ApplicationId appId4 = ApplicationId.newInstance((long)0L, (int)4);
        ApplicationClientProtocol appManager1 = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        Mockito.when((Object)appManager1.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId1))).thenReturn((Object)GetApplicationReportResponse.newInstance((ApplicationReport)this.newApplicationReport(appId1, YarnApplicationState.RUNNING, appUrl1)));
        Mockito.when((Object)appManager1.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId3))).thenReturn((Object)GetApplicationReportResponse.newInstance((ApplicationReport)this.newApplicationReport(appId3, YarnApplicationState.ACCEPTED, null)));
        ApplicationClientProtocol appManager2 = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        Mockito.when((Object)appManager2.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId2))).thenReturn((Object)GetApplicationReportResponse.newInstance((ApplicationReport)this.newApplicationReport(appId2, YarnApplicationState.RUNNING, appUrl2)));
        Mockito.when((Object)appManager2.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId4))).thenThrow(new Throwable[]{new ApplicationNotFoundException("APP NOT FOUND")});
        ApplicationHistoryProtocol historyManager = (ApplicationHistoryProtocol)Mockito.mock(ApplicationHistoryProtocol.class);
        Mockito.when((Object)historyManager.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId4))).thenReturn((Object)GetApplicationReportResponse.newInstance((ApplicationReport)this.newApplicationReport(appId4, YarnApplicationState.FINISHED, null)));
        FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance((Configuration)conf);
        facade.getStateStore().registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo1));
        facade.getStateStore().registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo2));
        facade.addApplicationHomeSubCluster(ApplicationHomeSubCluster.newInstance((ApplicationId)appId1, (SubClusterId)subClusterId1));
        facade.addApplicationHomeSubCluster(ApplicationHomeSubCluster.newInstance((ApplicationId)appId2, (SubClusterId)subClusterId2));
        facade.addApplicationHomeSubCluster(ApplicationHomeSubCluster.newInstance((ApplicationId)appId3, (SubClusterId)subClusterId1));
        facade.addApplicationHomeSubCluster(ApplicationHomeSubCluster.newInstance((ApplicationId)appId4, (SubClusterId)subClusterId2));
        WebAppProxyServerForTest proxy = new WebAppProxyServerForTest();
        proxy.init(conf);
        proxy.start();
        try {
            int proxyPort = proxy.proxy.proxyServer.getConnectorAddress(0).getPort();
            FedAppReportFetcher appReportFetcher = proxy.proxy.appReportFetcher;
            appReportFetcher.registerSubCluster(subClusterInfo1, appManager1);
            appReportFetcher.registerSubCluster(subClusterInfo2, appManager2);
            appReportFetcher.setHistoryManager(historyManager);
            URL url = new URL("http", "localhost", proxyPort, "/proxy/" + appId1.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            Assert.assertEquals((Object)("AM/" + appId1.toString()), (Object)this.readResponse(conn));
            conn.disconnect();
            url = new URL("http", "localhost", proxyPort, "/proxy/" + appId2.toString());
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            Assert.assertEquals((Object)("AM/" + appId2.toString()), (Object)this.readResponse(conn));
            conn.disconnect();
            url = new URL("http", "localhost", proxyPort, "/proxy/" + appId3.toString());
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            Assert.assertEquals((Object)("RM/" + appId3.toString()), (Object)this.readResponse(conn));
            conn.disconnect();
            url = new URL("http", "localhost", proxyPort, "/proxy/" + appId4.toString());
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            Assert.assertEquals((Object)("AHS/" + appId4.toString()), (Object)this.readResponse(conn));
            conn.disconnect();
        }
        finally {
            proxy.close();
        }
    }

    private ApplicationReport newApplicationReport(ApplicationId appId, YarnApplicationState state, String origTrackingUrl) {
        return ApplicationReport.newInstance((ApplicationId)appId, null, (String)"testuser", null, null, null, (int)0, null, (YarnApplicationState)state, null, null, (long)0L, (long)0L, (long)0L, null, null, (String)origTrackingUrl, (float)0.0f, null, null);
    }

    private String readResponse(HttpURLConnection conn) throws IOException {
        InputStream input = conn.getInputStream();
        byte[] bytes = new byte[input.available()];
        input.read(bytes);
        return new String(bytes);
    }

    static {
        mockServerPort = 0;
    }

    private class WebAppProxyForTest
    extends WebAppProxy {
        private HttpServer2 proxyServer;
        private FedAppReportFetcher appReportFetcher;

        private WebAppProxyForTest() {
        }

        protected void serviceStart() throws Exception {
            Configuration conf = this.getConfig();
            String bindAddress = conf.get("yarn.web-proxy.address");
            bindAddress = StringUtils.split((String)bindAddress, (char)':')[0];
            AccessControlList acl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
            this.proxyServer = new HttpServer2.Builder().setName("proxy").addEndpoint(URI.create(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + bindAddress + ":0")).setFindPort(true).setConf(conf).setACL(acl).build();
            this.proxyServer.addServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            this.appReportFetcher = new FedAppReportFetcher(conf);
            this.proxyServer.setAttribute("AppUrlFetcher", (Object)this.appReportFetcher);
            this.proxyServer.setAttribute("IsSecurityEnabled", (Object)Boolean.FALSE);
            String proxy = WebAppUtils.getProxyHostAndPort((Configuration)conf);
            String[] proxyParts = proxy.split(":");
            String proxyHost = proxyParts[0];
            this.proxyServer.setAttribute("proxyHost", (Object)proxyHost);
            this.proxyServer.start();
            LOG.info("Proxy server is started at port {}", (Object)this.proxyServer.getConnectorAddress(0).getPort());
        }
    }

    public static class MockWebServlet
    extends HttpServlet {
        private String role;

        public MockWebServlet(String role) {
            this.role = role;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            if (req.getPathInfo() != null) {
                resp.getWriter().write(this.role + req.getPathInfo());
            }
            resp.setStatus(200);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            ServletInputStream is = req.getInputStream();
            ServletOutputStream os = resp.getOutputStream();
            int c = is.read();
            while (c > -1) {
                os.write(c);
                c = is.read();
            }
            is.close();
            os.close();
            resp.setStatus(200);
        }
    }

    private class WebAppProxyServerForTest
    extends CompositeService {
        private WebAppProxyForTest proxy;

        WebAppProxyServerForTest() {
            super(WebAppProxyServer.class.getName());
            this.proxy = null;
        }

        protected synchronized void serviceInit(Configuration conf) throws Exception {
            this.proxy = new WebAppProxyForTest();
            this.addService((Service)this.proxy);
            super.serviceInit(conf);
        }
    }
}

