/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.util.TrackingUriPlugin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProxyUriUtils {
    @Test
    void testGetPathApplicationId() {
        Assertions.assertEquals((Object)"/proxy/application_100_0001", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)100L, (int)1)));
        Assertions.assertEquals((Object)"/proxy/application_6384623_0005", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5)));
    }

    @Test
    void testGetPathApplicationIdBad() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ProxyUriUtils.getPath(null));
    }

    @Test
    void testGetPathApplicationIdString() {
        Assertions.assertEquals((Object)"/proxy/application_6384623_0005", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), null));
        Assertions.assertEquals((Object)"/proxy/application_6384623_0005/static/app", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"/static/app"));
        Assertions.assertEquals((Object)"/proxy/application_6384623_0005/", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"/"));
        Assertions.assertEquals((Object)"/proxy/application_6384623_0005/some/path", (Object)ProxyUriUtils.getPath((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"some/path"));
    }

    @Test
    void testGetPathAndQuery() {
        Assertions.assertEquals((Object)"/proxy/application_6384623_0005/static/app?foo=bar", (Object)ProxyUriUtils.getPathAndQuery((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"/static/app", (String)"?foo=bar", (boolean)false));
        Assertions.assertEquals((Object)"/proxy/application_6384623_0005/static/app?foo=bar&bad=good&proxyapproved=true", (Object)ProxyUriUtils.getPathAndQuery((ApplicationId)BuilderUtils.newApplicationId((long)6384623L, (int)5), (String)"/static/app", (String)"foo=bar&bad=good", (boolean)true));
    }

    @Test
    void testGetProxyUri() throws Exception {
        URI originalUri = new URI("http://host.com/static/foo?bar=bar");
        URI proxyUri = new URI("http://proxy.net:8080/");
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        URI expected = new URI("http://proxy.net:8080/proxy/application_6384623_0005/static/foo?bar=bar");
        URI result = ProxyUriUtils.getProxyUri((URI)originalUri, (URI)proxyUri, (ApplicationId)id);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    void testGetProxyUriNull() throws Exception {
        URI originalUri = null;
        URI proxyUri = new URI("http://proxy.net:8080/");
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        URI expected = new URI("http://proxy.net:8080/proxy/application_6384623_0005/");
        URI result = ProxyUriUtils.getProxyUri(originalUri, (URI)proxyUri, (ApplicationId)id);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    void testGetProxyUriFromPluginsReturnsNullIfNoPlugins() throws URISyntaxException {
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)0);
        Assertions.assertNull((Object)ProxyUriUtils.getUriFromTrackingPlugins((ApplicationId)id, (List)list));
    }

    @Test
    void testGetProxyUriFromPluginsReturnsValidUriWhenAble() throws URISyntaxException {
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        list.add(new TrackingUriPlugin(){

            public URI getTrackingUri(ApplicationId id) throws URISyntaxException {
                return null;
            }
        });
        list.add(new TrackingUriPlugin(){

            public URI getTrackingUri(ApplicationId id) throws URISyntaxException {
                return new URI("http://history.server.net/");
            }
        });
        URI result = ProxyUriUtils.getUriFromTrackingPlugins((ApplicationId)id, (List)list);
        Assertions.assertNotNull((Object)result);
    }
}

