/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWebAppProxyServer {
    private WebAppProxyServer webAppProxy = null;
    private final String port = "8888";
    private final String proxyAddress = "localhost:8888";
    private YarnConfiguration conf = null;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.web-proxy.address", "localhost:8888");
        this.webAppProxy = new WebAppProxyServer();
    }

    @After
    public void tearDown() throws Exception {
        this.webAppProxy.stop();
    }

    @Test
    public void testStart() {
        this.webAppProxy.init((Configuration)this.conf);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)this.webAppProxy.getServiceState());
        this.webAppProxy.start();
        for (Service service : this.webAppProxy.getServices()) {
            if (!(service instanceof WebAppProxy)) continue;
            Assert.assertEquals((Object)"localhost:8888", (Object)((WebAppProxy)service).getBindAddress());
        }
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.webAppProxy.getServiceState());
    }

    @Test
    public void testStartWithBindHost() {
        String bindHost = "0.0.0.0";
        this.conf.set("yarn.web-proxy.bind-host", bindHost);
        this.webAppProxy.init((Configuration)this.conf);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)this.webAppProxy.getServiceState());
        this.webAppProxy.start();
        for (Service service : this.webAppProxy.getServices()) {
            if (!(service instanceof WebAppProxy)) continue;
            Assert.assertEquals((Object)(bindHost + ":" + "8888"), (Object)((WebAppProxy)service).getBindAddress());
        }
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.webAppProxy.getServiceState());
    }

    @Test
    public void testBindAddress() {
        this.conf = new YarnConfiguration();
        InetSocketAddress defaultBindAddress = WebAppProxyServer.getBindAddress((Configuration)this.conf);
        Assert.assertEquals((String)"Web Proxy default bind address port is incorrect", (long)9099L, (long)defaultBindAddress.getPort());
    }
}

