/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationReportPBImpl;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppProxyServerForTest
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppProxyServerForTest.class);
    private WebAppProxyForTest proxy = null;
    private final String trackingUrlProtocol;
    private final int originalPort;

    public WebAppProxyServerForTest(int originalPort, String trackingUrlProtocol) {
        super(WebAppProxyServer.class.getName());
        this.originalPort = originalPort;
        this.trackingUrlProtocol = trackingUrlProtocol == null || trackingUrlProtocol.isEmpty() ? "" : trackingUrlProtocol + "://";
    }

    public WebAppProxyServerForTest(int originalPort) {
        this(originalPort, "");
    }

    public static boolean isResponseCookiePresent(HttpURLConnection proxyConn, String expectedName, String expectedValue) {
        Map<String, List<String>> headerFields = proxyConn.getHeaderFields();
        List<String> cookiesHeader = headerFields.get("Set-Cookie");
        if (cookiesHeader != null) {
            for (String cookie : cookiesHeader) {
                HttpCookie c = HttpCookie.parse(cookie).get(0);
                if (!c.getName().equals(expectedName) || !c.getValue().equals(expectedValue)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void serviceInit(Configuration conf) throws Exception {
        this.proxy = new WebAppProxyForTest();
        this.addService((Service)this.proxy);
        super.serviceInit(conf);
    }

    public int getProxyPort() {
        return this.proxy.proxyServer.getConnectorAddress(0).getPort();
    }

    public AppReportFetcherForTest getAppReportFetcher() {
        return this.proxy.appReportFetcher;
    }

    public class AppReportFetcherForTest
    extends AppReportFetcher {
        private int answer;

        public AppReportFetcherForTest(Configuration conf) {
            super(conf);
            this.answer = 0;
        }

        public void setAnswer(int answer) {
            this.answer = answer;
        }

        public AppReportFetcher.FetchedAppReport getApplicationReport(ApplicationId appId) throws YarnException {
            if (this.answer == 0) {
                return this.getDefaultApplicationReport(appId);
            }
            if (this.answer == 1) {
                return null;
            }
            if (this.answer == 2) {
                AppReportFetcher.FetchedAppReport result = this.getDefaultApplicationReport(appId);
                result.getApplicationReport().setUser("user");
                return result;
            }
            if (this.answer == 3) {
                AppReportFetcher.FetchedAppReport result = this.getDefaultApplicationReport(appId);
                result.getApplicationReport().setYarnApplicationState(YarnApplicationState.KILLED);
                return result;
            }
            if (this.answer == 4) {
                throw new ApplicationNotFoundException("Application is not found");
            }
            if (this.answer == 5) {
                AppReportFetcher.FetchedAppReport result = this.getDefaultApplicationReport(appId);
                result.getApplicationReport().setOriginalTrackingUrl("localhost:" + WebAppProxyServerForTest.this.originalPort + "/foo/bar?a=b#main");
                result.getApplicationReport().setYarnApplicationState(YarnApplicationState.FINISHED);
                return result;
            }
            if (this.answer == 6) {
                return this.getDefaultApplicationReport(appId, false);
            }
            return null;
        }

        private AppReportFetcher.FetchedAppReport getDefaultApplicationReport(ApplicationId appId, boolean isTrackingUrl) {
            ApplicationReportPBImpl result = new ApplicationReportPBImpl();
            result.setApplicationId(appId);
            result.setYarnApplicationState(YarnApplicationState.RUNNING);
            result.setUser("dr.who");
            if (isTrackingUrl) {
                result.setOriginalTrackingUrl(WebAppProxyServerForTest.this.trackingUrlProtocol + "localhost:" + WebAppProxyServerForTest.this.originalPort + "/foo/bar");
            }
            AppReportFetcher.FetchedAppReport fetchedReport = WebAppProxyServerForTest.this.getConfig().getBoolean("yarn.timeline-service.generic-application-history.enabled", false) ? new AppReportFetcher.FetchedAppReport((ApplicationReport)result, AppReportFetcher.AppReportSource.AHS) : new AppReportFetcher.FetchedAppReport((ApplicationReport)result, AppReportFetcher.AppReportSource.RM);
            return fetchedReport;
        }

        private AppReportFetcher.FetchedAppReport getDefaultApplicationReport(ApplicationId appId) {
            return this.getDefaultApplicationReport(appId, true);
        }
    }

    private class WebAppProxyForTest
    extends WebAppProxy {
        HttpServer2 proxyServer;
        AppReportFetcherForTest appReportFetcher;

        private WebAppProxyForTest() {
        }

        protected void serviceStart() throws Exception {
            Configuration conf = this.getConfig();
            String bindAddress = conf.get("yarn.web-proxy.address");
            bindAddress = StringUtils.split((String)bindAddress, (char)':')[0];
            AccessControlList acl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
            this.proxyServer = new HttpServer2.Builder().setName("proxy").addEndpoint(URI.create(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + bindAddress + ":0")).setFindPort(true).setConf(conf).setACL(acl).build();
            this.proxyServer.addServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            this.appReportFetcher = new AppReportFetcherForTest(conf);
            this.proxyServer.setAttribute("AppUrlFetcher", (Object)this.appReportFetcher);
            this.proxyServer.setAttribute("IsSecurityEnabled", (Object)Boolean.TRUE);
            String proxy = WebAppUtils.getProxyHostAndPort((Configuration)conf);
            String[] proxyParts = proxy.split(":");
            String proxyHost = proxyParts[0];
            this.proxyServer.setAttribute("proxyHost", (Object)proxyHost);
            this.proxyServer.start();
            LOG.info("Proxy server is started at port {}", (Object)this.proxyServer.getConnectorAddress(0).getPort());
        }
    }
}

