/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.server.webproxy.TestWebAppProxyServlet;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServerForTest;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWebAppProxyServletWithSSL {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestWebAppProxyServletWithSSL.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(TestWebAppProxyServletWithSSL.class);
    private static String keystoresDir;
    private static HttpServer2 server;
    private static String sslConfDir;
    private static int originalPort;
    private static final Configuration configuration;

    public static void start() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestWebAppProxyServletWithSSL.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)configuration, (boolean)false);
        Configuration sslConf = new Configuration(false);
        sslConf.addResource("ssl-server.xml");
        sslConf.addResource("ssl-client.xml");
        server = new HttpServer2.Builder().setName("test").addEndpoint(new URI("https://localhost")).setConf(configuration).keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).build();
        server.addServlet("foobar", "/foo/bar", TestWebAppProxyServlet.TestServlet.class);
        server.start();
        URL baseUrl = new URL("https://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        originalPort = baseUrl.getPort();
        LOG.info("Running embedded HTTPS servlet container at: " + baseUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWebAppProxyServlet() throws Exception {
        configuration.set("yarn.web-proxy.address", "localhost:9090");
        configuration.setInt("hadoop.http.max.threads", 5);
        WebAppProxyServerForTest proxy = new WebAppProxyServerForTest(originalPort, "https");
        proxy.init(configuration);
        proxy.start();
        int proxyPort = proxy.getProxyPort();
        try {
            URL url = new URL("http://localhost:" + proxyPort + "/proxy/application_00_0");
            HttpURLConnection proxyConn = (HttpURLConnection)url.openConnection();
            proxyConn.setRequestProperty("Cookie", "checked_application_0_0000=true");
            proxyConn.connect();
            Assert.assertEquals((long)200L, (long)proxyConn.getResponseCode());
            Assert.assertTrue((boolean)WebAppProxyServerForTest.isResponseCookiePresent(proxyConn, "checked_application_0_0000", "true"));
        }
        finally {
            proxy.close();
        }
    }

    public static void stop() {
        try {
            server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        originalPort = 0;
        configuration = new Configuration();
    }
}

