/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderWebServicesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineReaderWhitelistAuthorizationFilter
implements Filter {
    public static final String EMPTY_STRING = "";
    private static final Logger LOG = LoggerFactory.getLogger(TimelineReaderWhitelistAuthorizationFilter.class);
    private boolean isWhitelistReadAuthEnabled = false;
    private AccessControlList allowedUsersAclList;
    private AccessControlList adminAclList;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.isWhitelistReadAuthEnabled) {
            UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(httpRequest);
            if (callerUGI == null) {
                String msg = "Unable to obtain user name, user not authenticated";
                throw new AuthorizationException(msg);
            }
            if (!this.adminAclList.isUserAllowed(callerUGI) && !this.allowedUsersAclList.isUserAllowed(callerUGI)) {
                String userName = callerUGI.getShortUserName();
                String msg = "User " + userName + " is not allowed to read TimelineService V2 data.";
                httpResponse.sendError(403, msg);
                return;
            }
        }
        if (chain != null) {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig conf) throws ServletException {
        String isWhitelistReadAuthEnabledStr = conf.getInitParameter("yarn.timeline-service.read.authentication.enabled");
        this.isWhitelistReadAuthEnabled = isWhitelistReadAuthEnabledStr == null ? YarnConfiguration.DEFAULT_TIMELINE_SERVICE_READ_AUTH_ENABLED.booleanValue() : Boolean.valueOf(isWhitelistReadAuthEnabledStr).booleanValue();
        if (this.isWhitelistReadAuthEnabled) {
            String listAllowedUsers = conf.getInitParameter("yarn.timeline-service.read.allowed.users");
            if (StringUtils.isEmpty((CharSequence)listAllowedUsers)) {
                listAllowedUsers = EMPTY_STRING;
            }
            LOG.info("listAllowedUsers=" + listAllowedUsers);
            this.allowedUsersAclList = new AccessControlList(listAllowedUsers);
            LOG.info("allowedUsersAclList=" + this.allowedUsersAclList.getUsers());
            String adminAclListStr = conf.getInitParameter("yarn.admin.acl");
            if (StringUtils.isEmpty((CharSequence)adminAclListStr)) {
                adminAclListStr = EMPTY_STRING;
                LOG.info("adminAclList not set, hence setting it to \"\"");
            }
            this.adminAclList = new AccessControlList(adminAclListStr);
            LOG.info("adminAclList=" + this.adminAclList.getUsers());
        }
    }
}

