/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TestFileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTimelineReaderWebServicesACL {
    private static final String ROOT_DIR = new File("target", TestTimelineReaderWebServicesACL.class.getSimpleName()).getAbsolutePath();
    private int serverPort;
    private TimelineReaderServer server;
    private static final String ADMIN = "yarn";

    @BeforeClass
    public static void setup() throws Exception {
        TestFileSystemTimelineReaderImpl.initializeDataDirectory(ROOT_DIR);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)new File(ROOT_DIR));
    }

    @Before
    public void init() throws Exception {
        try {
            YarnConfiguration config = new YarnConfiguration();
            config.setBoolean("yarn.timeline-service.enabled", true);
            config.setFloat("yarn.timeline-service.version", 2.0f);
            config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
            config.set("yarn.resourcemanager.cluster-id", "cluster1");
            config.setClass("yarn.timeline-service.reader.class", FileSystemTimelineReaderImpl.class, TimelineReader.class);
            config.set("yarn.timeline-service.fs-writer.root-dir", ROOT_DIR);
            config.setBoolean("yarn.webapp.filter-entity-list-by-user", true);
            config.setBoolean("yarn.acl.enable", true);
            config.set("yarn.admin.acl", ADMIN);
            this.server = new TimelineReaderServer();
            this.server.init((Configuration)config);
            this.server.start();
            this.serverPort = this.server.getWebServerPort();
        }
        catch (Exception e) {
            Assert.fail((String)"Web server failed to start");
        }
    }

    @After
    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    private static ClientResponse verifyHttpResponse(Client client, URI uri, ClientResponse.Status expectedStatus) {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)client.resource(uri).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((long)resp.getStatusInfo().getStatusCode(), (long)expectedStatus.getStatusCode());
        return resp;
    }

    private static Client createClient() {
        DefaultClientConfig cfg = new DefaultClientConfig();
        cfg.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        return new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)new DummyURLConnectionFactory()), (ClientConfig)cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityTypes() throws Exception {
        Client client = TestTimelineReaderWebServicesACL.createClient();
        try {
            String unAuthorizedUser = "user2";
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + unAuthorizedUser);
            String msg = "User " + unAuthorizedUser + " is not allowed to read TimelineService V2 data.";
            ClientResponse resp = TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, ClientResponse.Status.FORBIDDEN);
            Assert.assertTrue((boolean)((String)resp.getEntity(String.class)).contains(msg));
            String authorizedUser = "user1";
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + authorizedUser);
            TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, ClientResponse.Status.OK);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + ADMIN);
            TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, ClientResponse.Status.OK);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + authorizedUser + "&userid=" + authorizedUser);
            TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, ClientResponse.Status.OK);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + authorizedUser + "&userid=" + unAuthorizedUser);
            TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, ClientResponse.Status.FORBIDDEN);
        }
        finally {
            client.destroy();
        }
    }

    private static class DummyURLConnectionFactory
    implements HttpURLConnectionFactory {
        private DummyURLConnectionFactory() {
        }

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            try {
                return (HttpURLConnection)url.openConnection();
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
        }
    }
}

