/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineReaderServer {
    @Test(timeout=60000L)
    public void testStartStopServer() throws Exception {
        TimelineReaderServer server = new TimelineReaderServer();
        YarnConfiguration config = new YarnConfiguration();
        config.setBoolean("yarn.timeline-service.enabled", true);
        config.setFloat("yarn.timeline-service.version", 2.0f);
        config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
        config.setClass("yarn.timeline-service.reader.class", FileSystemTimelineReaderImpl.class, TimelineReader.class);
        try {
            server.init((Configuration)config);
            Assert.assertEquals((Object)Service.STATE.INITED, (Object)server.getServiceState());
            Assert.assertEquals((long)2L, (long)server.getServices().size());
            server.start();
            Assert.assertEquals((Object)Service.STATE.STARTED, (Object)server.getServiceState());
            server.stop();
            Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)server.getServiceState());
        }
        finally {
            server.stop();
        }
    }

    @Test(timeout=60000L, expected=YarnRuntimeException.class)
    public void testTimelineReaderServerWithInvalidTimelineReader() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 2.0f);
        conf.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
        conf.set("yarn.timeline-service.reader.class", Object.class.getName());
        TestTimelineReaderServer.runTimelineReaderServerWithConfig((Configuration)conf);
    }

    @Test(timeout=60000L, expected=YarnRuntimeException.class)
    public void testTimelineReaderServerWithNonexistentTimelineReader() {
        String nonexistentTimelineReaderClass = "org.apache.org.yarn.server.timelineservice.storage.XXXXXXXX";
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 2.0f);
        conf.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
        conf.set("yarn.timeline-service.reader.class", nonexistentTimelineReaderClass);
        TestTimelineReaderServer.runTimelineReaderServerWithConfig((Configuration)conf);
    }

    private static void runTimelineReaderServerWithConfig(Configuration conf) {
        TimelineReaderServer server = new TimelineReaderServer();
        try {
            server.init(conf);
            server.start();
        }
        finally {
            server.stop();
        }
    }
}

