/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.junit.Assert;

public abstract class AbstractTimelineReaderHBaseTestBase {
    private static int serverPort;
    private static TimelineReaderServer server;
    private static HBaseTestingUtility util;

    public static void setup() throws Exception {
        util = new HBaseTestingUtility();
        Configuration conf = util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        util.startMiniCluster();
        DataGeneratorForTest.createSchema(util.getConfiguration());
    }

    public static void tearDown() throws Exception {
        if (server != null) {
            server.stop();
            server = null;
        }
        if (util != null) {
            util.shutdownMiniCluster();
        }
    }

    protected static void initialize() throws Exception {
        try {
            Configuration config = util.getConfiguration();
            config.setBoolean("yarn.timeline-service.enabled", true);
            config.setFloat("yarn.timeline-service.version", 2.0f);
            config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
            config.set("yarn.resourcemanager.cluster-id", "cluster1");
            config.set("yarn.timeline-service.reader.class", "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl");
            config.setInt("hfile.format.version", 3);
            server = new TimelineReaderServer(){

                protected void addFilters(Configuration conf) {
                }
            };
            server.init(config);
            server.start();
            serverPort = server.getWebServerPort();
        }
        catch (Exception e) {
            Assert.fail((String)"Web server failed to start");
        }
    }

    protected Client createClient() {
        DefaultClientConfig cfg = new DefaultClientConfig();
        cfg.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        return new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)new DummyURLConnectionFactory()), (ClientConfig)cfg);
    }

    protected ClientResponse getResponse(Client client, URI uri) throws Exception {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)client.resource(uri).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        if (resp == null || resp.getStatusInfo().getStatusCode() != ClientResponse.Status.OK.getStatusCode()) {
            String msg = "";
            if (resp != null) {
                msg = String.valueOf(resp.getStatusInfo().getStatusCode());
            }
            throw new IOException("Incorrect response from timeline reader. Status=" + msg);
        }
        return resp;
    }

    protected void verifyHttpResponse(Client client, URI uri, ClientResponse.Status status) {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)client.resource(uri).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        Assert.assertNotNull((Object)resp);
        Assert.assertTrue((String)("Response from server should have been " + status), (resp.getStatusInfo().getStatusCode() == status.getStatusCode() ? 1 : 0) != 0);
        System.out.println("Response is: " + (String)resp.getEntity(String.class));
    }

    protected List<FlowActivityEntity> verifyFlowEntites(Client client, URI uri, int noOfEntities) throws Exception {
        ClientResponse resp = this.getResponse(client, uri);
        List entities = (List)resp.getEntity((GenericType)new GenericType<List<FlowActivityEntity>>(){});
        Assert.assertNotNull((Object)entities);
        Assert.assertEquals((long)noOfEntities, (long)entities.size());
        return entities;
    }

    protected static HBaseTestingUtility getHBaseTestingUtility() {
        return util;
    }

    public static int getServerPort() {
        return serverPort;
    }

    protected static class DummyURLConnectionFactory
    implements HttpURLConnectionFactory {
        protected DummyURLConnectionFactory() {
        }

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            try {
                return (HttpURLConnection)url.openConnection();
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
        }
    }
}

