/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

public final class TestFlowDataGenerator {
    private static final String METRIC_1 = "MAP_SLOT_MILLIS";
    private static final String METRIC_2 = "HDFS_BYTES_READ";
    public static final long END_TS_INCR = 10000L;

    private TestFlowDataGenerator() {
    }

    public static TimelineEntity getEntityMetricsApp1(long insertTs, Configuration c1) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunMetrics_test";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        long cTime = 1425016501000L;
        entity.setCreatedTime(Long.valueOf(cTime));
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric m1 = new TimelineMetric();
        m1.setId(METRIC_1);
        HashMap<Long, Long> metricValues = new HashMap<Long, Long>();
        long ts = insertTs;
        for (int k = 1; k < 100; ++k) {
            metricValues.put(ts - (long)k * 200000L, 20L);
        }
        metricValues.put(ts - 80000L, 40L);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues(metricValues);
        metrics.add(m1);
        TimelineMetric m2 = new TimelineMetric();
        m2.setId(METRIC_2);
        metricValues = new HashMap();
        ts = System.currentTimeMillis();
        for (int k = 1; k < 100; ++k) {
            metricValues.put(ts - (long)k * 100000L, 31L);
        }
        metricValues.put(ts - 80000L, 57L);
        m2.setType(TimelineMetric.Type.TIME_SERIES);
        m2.setValues(metricValues);
        metrics.add(m2);
        entity.addMetrics(metrics);
        return entity;
    }

    public static TimelineEntity getEntityMetricsApp1Complete(long insertTs, Configuration c1) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunMetrics_test";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        long cTime = 1425016501000L;
        entity.setCreatedTime(Long.valueOf(cTime));
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric m1 = new TimelineMetric();
        m1.setId(METRIC_1);
        HashMap<Long, Long> metricValues = new HashMap<Long, Long>();
        long ts = insertTs;
        metricValues.put(ts - 80000L, 40L);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues(metricValues);
        metrics.add(m1);
        TimelineMetric m2 = new TimelineMetric();
        m2.setId(METRIC_2);
        metricValues = new HashMap();
        ts = insertTs;
        metricValues.put(ts - 80000L, 57L);
        m2.setType(TimelineMetric.Type.TIME_SERIES);
        m2.setValues(metricValues);
        metrics.add(m2);
        entity.addMetrics(metrics);
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_FINISHED");
        event.setTimestamp(insertTs);
        event.addInfo("done", (Object)("insertTs=" + insertTs));
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getEntityMetricsApp1(long insertTs) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunMetrics_test";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        long cTime = 1425016501000L;
        entity.setCreatedTime(Long.valueOf(cTime));
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric m1 = new TimelineMetric();
        m1.setId(METRIC_1);
        HashMap<Long, Long> metricValues = new HashMap<Long, Long>();
        long ts = insertTs;
        metricValues.put(ts - 100000L, 2L);
        metricValues.put(ts - 80000L, 40L);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues(metricValues);
        metrics.add(m1);
        TimelineMetric m2 = new TimelineMetric();
        m2.setId(METRIC_2);
        metricValues = new HashMap();
        ts = insertTs;
        metricValues.put(ts - 100000L, 31L);
        metricValues.put(ts - 80000L, 57L);
        m2.setType(TimelineMetric.Type.TIME_SERIES);
        m2.setValues(metricValues);
        metrics.add(m2);
        entity.addMetrics(metrics);
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        long endTs = 1439379885000L;
        event.setTimestamp(endTs);
        String expKey = "foo_event_greater";
        String expVal = "test_app_greater";
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getEntityMetricsApp2(long insertTs) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunMetrics_test";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        long cTime = 1425016501000L;
        entity.setCreatedTime(Long.valueOf(cTime));
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric m1 = new TimelineMetric();
        m1.setId(METRIC_1);
        HashMap<Long, Long> metricValues = new HashMap<Long, Long>();
        long ts = insertTs;
        metricValues.put(ts - 100000L, 5L);
        metricValues.put(ts - 80000L, 101L);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues(metricValues);
        metrics.add(m1);
        entity.addMetrics(metrics);
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        long endTs = 1439379885000L;
        event.setTimestamp(endTs);
        String expKey = "foo_event_greater";
        String expVal = "test_app_greater";
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getEntity1() {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunHello";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        long cTime = 1425026901000L;
        entity.setCreatedTime(Long.valueOf(cTime));
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric m1 = new TimelineMetric();
        m1.setId(METRIC_1);
        HashMap<Long, Long> metricValues = new HashMap<Long, Long>();
        long ts = System.currentTimeMillis();
        metricValues.put(ts - 120000L, 100000000L);
        metricValues.put(ts - 100000L, 200000000L);
        metricValues.put(ts - 80000L, 300000000L);
        metricValues.put(ts - 60000L, 400000000L);
        metricValues.put(ts - 40000L, 50000000000L);
        metricValues.put(ts - 20000L, 60000000000L);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues(metricValues);
        metrics.add(m1);
        entity.addMetrics(metrics);
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        event.setTimestamp(cTime);
        String expKey = "foo_event";
        String expVal = "test";
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        event = new TimelineEvent();
        event.setId("YARN_APPLICATION_FINISHED");
        long expTs = cTime + 21600000L;
        event.setTimestamp(expTs);
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getAFullEntity(long ts, long endTs) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunFullEntity";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        entity.setCreatedTime(Long.valueOf(ts));
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric m1 = new TimelineMetric();
        m1.setId(METRIC_1);
        HashMap<Long, Long> metricValues = new HashMap<Long, Long>();
        metricValues.put(ts - 120000L, 100000000L);
        metricValues.put(ts - 100000L, 200000000L);
        metricValues.put(ts - 80000L, 300000000L);
        metricValues.put(ts - 60000L, 400000000L);
        metricValues.put(ts - 40000L, 50000000000L);
        metricValues.put(ts - 20000L, 60000000000L);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues(metricValues);
        metrics.add(m1);
        TimelineMetric m2 = new TimelineMetric();
        m2.setId(METRIC_2);
        metricValues = new HashMap();
        metricValues.put(ts - 900000L, 31L);
        metricValues.put(ts - 30000L, 57L);
        m2.setType(TimelineMetric.Type.TIME_SERIES);
        m2.setValues(metricValues);
        metrics.add(m2);
        entity.addMetrics(metrics);
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        event.setTimestamp(ts);
        String expKey = "foo_event";
        String expVal = "test";
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        event = new TimelineEvent();
        event.setId("YARN_APPLICATION_FINISHED");
        long expTs = ts + 21600000L;
        event.setTimestamp(expTs);
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getEntityGreaterStartTime(long startTs) {
        TimelineEntity entity = new TimelineEntity();
        entity.setCreatedTime(Long.valueOf(startTs));
        entity.setId("flowRunHello with greater start time");
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setType(type);
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        event.setTimestamp(startTs);
        String expKey = "foo_event_greater";
        String expVal = "test_app_greater";
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getEntityMaxEndTime(long endTs) {
        TimelineEntity entity = new TimelineEntity();
        entity.setId("flowRunHello Max End time");
        entity.setType(TimelineEntityType.YARN_APPLICATION.toString());
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_FINISHED");
        event.setTimestamp(endTs);
        String expKey = "foo_even_max_ finished";
        String expVal = "test_app_max_finished";
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getEntityMinStartTime(long startTs) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunHelloMInStartTime";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        entity.setCreatedTime(Long.valueOf(startTs));
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        event.setTimestamp(startTs);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getMinFlushEntity(long startTs) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunHelloFlushEntityMin";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        entity.setCreatedTime(Long.valueOf(startTs));
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        event.setTimestamp(startTs);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getMaxFlushEntity(long startTs) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowRunHelloFlushEntityMax";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        entity.setCreatedTime(Long.valueOf(startTs));
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_FINISHED");
        event.setTimestamp(startTs + 10000L);
        entity.addEvent(event);
        return entity;
    }

    public static TimelineEntity getFlowApp1(long appCreatedTime) {
        TimelineEntity entity = new TimelineEntity();
        String id = "flowActivity_test";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        entity.setCreatedTime(Long.valueOf(appCreatedTime));
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        event.setTimestamp(appCreatedTime);
        String expKey = "foo_event";
        String expVal = "test";
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        return entity;
    }
}

