/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineDomain;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnRWHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.domain.DomainColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.domain.DomainRowKey;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHBaseTimelineStorageDomain {
    private static HBaseTestingUtility util;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util = new HBaseTestingUtility();
        Configuration conf = util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        util.startMiniCluster();
        DataGeneratorForTest.createSchema(util.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDomainIdTable() throws Exception {
        TimelineDomain domain2;
        long l = System.currentTimeMillis();
        HBaseTimelineWriterImpl hbi = null;
        Configuration c1 = util.getConfiguration();
        String clusterId = "yarn-cluster";
        TimelineCollectorContext context = new TimelineCollectorContext(clusterId, null, null, null, null, null);
        try {
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            domain2 = new TimelineDomain();
            domain2.setCreatedTime(Long.valueOf(l));
            domain2.setDescription("domain-2");
            domain2.setId("domain-2");
            domain2.setModifiedTime(Long.valueOf(l));
            domain2.setOwner("owner1");
            domain2.setReaders("user1,user2 group1,group2");
            domain2.setWriters("writer1,writer2");
            hbi.write(context, domain2);
            hbi.flush();
        }
        finally {
            if (hbi != null) {
                hbi.close();
            }
        }
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTableRW.getTableName((Configuration)c1, (String)"yarn.timeline-service.domain.table.name", (String)"timelineservice.domain"));
        byte[] startRow = new DomainRowKey(clusterId, domain2.getId()).getRowKey();
        Get g = new Get(startRow);
        Result result = table1.get(g);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        byte[] row = result.getRow();
        DomainRowKey domainRowKey = DomainRowKey.parseRowKey((byte[])row);
        Assert.assertEquals((Object)domain2.getId(), (Object)domainRowKey.getDomainId());
        Assert.assertEquals((Object)clusterId, (Object)domainRowKey.getClusterId());
        Long cTime = (Long)ColumnRWHelper.readResult((Result)result, (Column)DomainColumn.CREATED_TIME);
        String description = (String)ColumnRWHelper.readResult((Result)result, (Column)DomainColumn.DESCRIPTION);
        Long mTime = (Long)ColumnRWHelper.readResult((Result)result, (Column)DomainColumn.MODIFICATION_TIME);
        String owners = (String)ColumnRWHelper.readResult((Result)result, (Column)DomainColumn.OWNER);
        String readers = (String)ColumnRWHelper.readResult((Result)result, (Column)DomainColumn.READERS);
        String writers = (String)ColumnRWHelper.readResult((Result)result, (Column)DomainColumn.WRITERS);
        Assert.assertEquals((long)l, (long)cTime);
        Assert.assertEquals((long)l, (long)mTime);
        Assert.assertEquals((Object)"domain-2", (Object)description);
        Assert.assertEquals((Object)"owner1", (Object)owners);
        Assert.assertEquals((Object)"user1,user2 group1,group2", (Object)readers);
        Assert.assertEquals((Object)"writer1,writer2", (Object)writers);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (util != null) {
            util.shutdownMiniCluster();
        }
    }
}

