/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.AppIdKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineSchemaUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.domain.DomainRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationRowKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRowKeys {
    private static final String QUALIFIER_SEP = Separator.QUALIFIERS.getValue();
    private static final byte[] QUALIFIER_SEP_BYTES = Bytes.toBytes((String)QUALIFIER_SEP);
    private static final String CLUSTER = "cl" + QUALIFIER_SEP + "uster";
    private static final String USER = QUALIFIER_SEP + "user";
    private static final String SUB_APP_USER = QUALIFIER_SEP + "subAppUser";
    private static final String FLOW_NAME = "dummy_" + QUALIFIER_SEP + "flow" + QUALIFIER_SEP;
    private static final Long FLOW_RUN_ID;
    private static final String APPLICATION_ID;

    private static void verifyRowPrefixBytes(byte[] byteRowKeyPrefix) {
        int sepLen = QUALIFIER_SEP_BYTES.length;
        for (int i = 0; i < sepLen; ++i) {
            Assertions.assertTrue((byteRowKeyPrefix[byteRowKeyPrefix.length - sepLen + i] == QUALIFIER_SEP_BYTES[i] ? 1 : 0) != 0, (String)"Row key prefix not encoded properly.");
        }
    }

    @Test
    void testApplicationRowKey() {
        byte[] byteRowKey = new ApplicationRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID).getRowKey();
        ApplicationRowKey rowKey = ApplicationRowKey.parseRowKey((byte[])byteRowKey);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assertions.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assertions.assertEquals((Long)FLOW_RUN_ID, (Long)rowKey.getFlowRunId());
        Assertions.assertEquals((Object)APPLICATION_ID, (Object)rowKey.getAppId());
        byte[] byteRowKeyPrefix = new ApplicationRowKeyPrefix(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID).getRowKeyPrefix();
        byte[][] splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 8, 0});
        Assertions.assertEquals((int)5, (int)splits.length);
        Assertions.assertEquals((int)0, (int)splits[4].length);
        Assertions.assertEquals((Object)FLOW_NAME, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[2])));
        Assertions.assertEquals((Long)FLOW_RUN_ID, (Long)LongConverter.invertLong((long)Bytes.toLong((byte[])splits[3])));
        TestRowKeys.verifyRowPrefixBytes(byteRowKeyPrefix);
        byteRowKeyPrefix = new ApplicationRowKeyPrefix(CLUSTER, USER, FLOW_NAME).getRowKeyPrefix();
        splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 0});
        Assertions.assertEquals((int)4, (int)splits.length);
        Assertions.assertEquals((int)0, (int)splits[3].length);
        Assertions.assertEquals((Object)FLOW_NAME, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[2])));
        TestRowKeys.verifyRowPrefixBytes(byteRowKeyPrefix);
    }

    @Test
    void testAppToFlowRowKey() {
        byte[] byteRowKey = new AppToFlowRowKey(APPLICATION_ID).getRowKey();
        AppToFlowRowKey rowKey = AppToFlowRowKey.parseRowKey((byte[])byteRowKey);
        Assertions.assertEquals((Object)APPLICATION_ID, (Object)rowKey.getAppId());
    }

    @Test
    void testEntityRowKey() {
        TimelineEntity entity = new TimelineEntity();
        entity.setId("!ent!ity!!id!");
        entity.setType("entity!Type");
        entity.setIdPrefix(54321L);
        byte[] byteRowKey = new EntityRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID, entity.getType(), Long.valueOf(entity.getIdPrefix()), entity.getId()).getRowKey();
        EntityRowKey rowKey = EntityRowKey.parseRowKey((byte[])byteRowKey);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assertions.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assertions.assertEquals((Long)FLOW_RUN_ID, (Long)rowKey.getFlowRunId());
        Assertions.assertEquals((Object)APPLICATION_ID, (Object)rowKey.getAppId());
        Assertions.assertEquals((Object)entity.getType(), (Object)rowKey.getEntityType());
        Assertions.assertEquals((long)entity.getIdPrefix(), (long)rowKey.getEntityIdPrefix());
        Assertions.assertEquals((Object)entity.getId(), (Object)rowKey.getEntityId());
        byte[] byteRowKeyPrefix = new EntityRowKeyPrefix(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID, entity.getType(), null, null).getRowKeyPrefix();
        byte[][] splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 8, AppIdKeyConverter.getKeySize(), 0, 8, 0});
        Assertions.assertEquals((int)7, (int)splits.length);
        Assertions.assertEquals((Object)APPLICATION_ID, (Object)new AppIdKeyConverter().decode(splits[4]));
        Assertions.assertEquals((Object)entity.getType(), (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[5])));
        TestRowKeys.verifyRowPrefixBytes(byteRowKeyPrefix);
        byteRowKeyPrefix = new EntityRowKeyPrefix(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID).getRowKeyPrefix();
        splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 8, AppIdKeyConverter.getKeySize(), 0});
        Assertions.assertEquals((int)6, (int)splits.length);
        Assertions.assertEquals((int)0, (int)splits[5].length);
        AppIdKeyConverter appIdKeyConverter = new AppIdKeyConverter();
        Assertions.assertEquals((Object)APPLICATION_ID, (Object)appIdKeyConverter.decode(splits[4]));
        TestRowKeys.verifyRowPrefixBytes(byteRowKeyPrefix);
    }

    @Test
    void testFlowActivityRowKey() {
        Long ts = 1459900830000L;
        Long dayTimestamp = HBaseTimelineSchemaUtils.getTopOfTheDayTimestamp((long)ts);
        byte[] byteRowKey = new FlowActivityRowKey(CLUSTER, ts, USER, FLOW_NAME).getRowKey();
        FlowActivityRowKey rowKey = FlowActivityRowKey.parseRowKey((byte[])byteRowKey);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Long)dayTimestamp, (Long)rowKey.getDayTimestamp());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assertions.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        byte[] byteRowKeyPrefix = new FlowActivityRowKeyPrefix(CLUSTER).getRowKeyPrefix();
        byte[][] splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0});
        Assertions.assertEquals((int)2, (int)splits.length);
        Assertions.assertEquals((int)0, (int)splits[1].length);
        Assertions.assertEquals((Object)CLUSTER, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[0])));
        TestRowKeys.verifyRowPrefixBytes(byteRowKeyPrefix);
        byteRowKeyPrefix = new FlowActivityRowKeyPrefix(CLUSTER, ts).getRowKeyPrefix();
        splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 8, 0});
        Assertions.assertEquals((int)3, (int)splits.length);
        Assertions.assertEquals((int)0, (int)splits[2].length);
        Assertions.assertEquals((Object)CLUSTER, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[0])));
        Assertions.assertEquals((Long)ts, (Long)LongConverter.invertLong((long)Bytes.toLong((byte[])splits[1])));
        TestRowKeys.verifyRowPrefixBytes(byteRowKeyPrefix);
    }

    @Test
    void testFlowRunRowKey() {
        byte[] byteRowKey = new FlowRunRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID).getRowKey();
        FlowRunRowKey rowKey = FlowRunRowKey.parseRowKey((byte[])byteRowKey);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assertions.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assertions.assertEquals((Long)FLOW_RUN_ID, (Long)rowKey.getFlowRunId());
        byte[] byteRowKeyPrefix = new FlowRunRowKey(CLUSTER, USER, FLOW_NAME, null).getRowKey();
        byte[][] splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 0});
        Assertions.assertEquals((int)4, (int)splits.length);
        Assertions.assertEquals((int)0, (int)splits[3].length);
        Assertions.assertEquals((Object)FLOW_NAME, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[2])));
        TestRowKeys.verifyRowPrefixBytes(byteRowKeyPrefix);
    }

    @Test
    void testSubAppRowKey() {
        TimelineEntity entity = new TimelineEntity();
        entity.setId("entity1");
        entity.setType("DAG");
        entity.setIdPrefix(54321L);
        byte[] byteRowKey = new SubApplicationRowKey(SUB_APP_USER, CLUSTER, entity.getType(), Long.valueOf(entity.getIdPrefix()), entity.getId(), USER).getRowKey();
        SubApplicationRowKey rowKey = SubApplicationRowKey.parseRowKey((byte[])byteRowKey);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)SUB_APP_USER, (Object)rowKey.getSubAppUserId());
        Assertions.assertEquals((Object)entity.getType(), (Object)rowKey.getEntityType());
        Assertions.assertEquals((long)entity.getIdPrefix(), (long)rowKey.getEntityIdPrefix());
        Assertions.assertEquals((Object)entity.getId(), (Object)rowKey.getEntityId());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
    }

    @Test
    void testDomainRowKey() {
        String clusterId = "cluster1@dc1";
        String domainId = "helloworld";
        byte[] byteRowKey = new DomainRowKey(clusterId, domainId).getRowKey();
        DomainRowKey rowKey = DomainRowKey.parseRowKey((byte[])byteRowKey);
        Assertions.assertEquals((Object)clusterId, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)domainId, (Object)rowKey.getDomainId());
        String rowKeyStr = rowKey.getRowKeyAsString();
        DomainRowKey drk = DomainRowKey.parseRowKeyFromString((String)rowKeyStr);
        Assertions.assertEquals((Object)drk.getClusterId(), (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)drk.getDomainId(), (Object)rowKey.getDomainId());
    }

    @Test
    void testDomainRowKeySpecialChars() {
        String clusterId = "cluster1!temp!dc1";
        String domainId = "hello=world";
        byte[] byteRowKey = new DomainRowKey(clusterId, domainId).getRowKey();
        DomainRowKey rowKey = DomainRowKey.parseRowKey((byte[])byteRowKey);
        Assertions.assertEquals((Object)clusterId, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)domainId, (Object)rowKey.getDomainId());
        String rowKeyStr = rowKey.getRowKeyAsString();
        DomainRowKey drk = DomainRowKey.parseRowKeyFromString((String)rowKeyStr);
        Assertions.assertEquals((Object)drk.getClusterId(), (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)drk.getDomainId(), (Object)rowKey.getDomainId());
    }

    static {
        long runid = 9223372036854774907L;
        byte[] longMaxByteArr = Bytes.toBytes((long)Long.MAX_VALUE);
        int sepByteLen = QUALIFIER_SEP_BYTES.length;
        byte[] byteArr = Bytes.toBytes((long)runid);
        if (sepByteLen <= byteArr.length) {
            for (int i = 0; i < sepByteLen; ++i) {
                byteArr[i] = (byte)(longMaxByteArr[i] - QUALIFIER_SEP_BYTES[i]);
            }
        }
        FLOW_RUN_ID = Bytes.toLong((byte[])byteArr);
        long clusterTs = System.currentTimeMillis();
        byteArr = Bytes.toBytes((long)clusterTs);
        if (sepByteLen <= byteArr.length) {
            for (int i = 0; i < sepByteLen; ++i) {
                byteArr[byteArr.length - sepByteLen + i] = (byte)(longMaxByteArr[byteArr.length - sepByteLen + i] - QUALIFIER_SEP_BYTES[i]);
            }
        }
        clusterTs = Bytes.toLong((byte[])byteArr);
        int seqId = 222;
        APPLICATION_ID = ApplicationId.newInstance((long)clusterTs, (int)seqId).toString();
    }
}

