/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.collection;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTestUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineMetricSubDoc;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity.FlowActivityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowrun.FlowRunDocument;
import org.junit.Assert;
import org.junit.Test;

public class TestDocumentOperations {
    private static final String MEMORY_ID = "MEMORY";
    private static final String FLOW_NAME = "DistributedShell";
    private static final String FLOW_VERSION = "1";

    @Test
    public void testTimelineEntityDocMergeOperation() throws IOException {
        TimelineEntityDocument actualEntityDoc = new TimelineEntityDocument();
        TimelineEntityDocument expectedEntityDoc = DocumentStoreTestUtils.bakeTimelineEntityDoc();
        Assert.assertEquals((long)1L, (long)actualEntityDoc.getInfo().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getMetrics().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getEvents().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getConfigs().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getIsRelatedToEntities().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getRelatesToEntities().size());
        actualEntityDoc.merge(expectedEntityDoc);
        Assert.assertEquals((long)expectedEntityDoc.getInfo().size(), (long)actualEntityDoc.getInfo().size());
        Assert.assertEquals((long)expectedEntityDoc.getMetrics().size(), (long)actualEntityDoc.getMetrics().size());
        Assert.assertEquals((long)expectedEntityDoc.getEvents().size(), (long)actualEntityDoc.getEvents().size());
        Assert.assertEquals((long)expectedEntityDoc.getConfigs().size(), (long)actualEntityDoc.getConfigs().size());
        Assert.assertEquals((long)expectedEntityDoc.getRelatesToEntities().size(), (long)actualEntityDoc.getIsRelatedToEntities().size());
        Assert.assertEquals((long)expectedEntityDoc.getRelatesToEntities().size(), (long)actualEntityDoc.getRelatesToEntities().size());
    }

    @Test
    public void testFlowActivityDocMergeOperation() throws IOException {
        FlowActivityDocument actualFlowActivityDoc = new FlowActivityDocument();
        FlowActivityDocument expectedFlowActivityDoc = DocumentStoreTestUtils.bakeFlowActivityDoc();
        Assert.assertEquals((long)0L, (long)actualFlowActivityDoc.getDayTimestamp());
        Assert.assertEquals((long)0L, (long)actualFlowActivityDoc.getFlowActivities().size());
        Assert.assertNull((Object)actualFlowActivityDoc.getFlowName());
        Assert.assertEquals((Object)TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), (Object)actualFlowActivityDoc.getType());
        Assert.assertNull((Object)actualFlowActivityDoc.getUser());
        Assert.assertNull((Object)actualFlowActivityDoc.getId());
        actualFlowActivityDoc.merge(expectedFlowActivityDoc);
        Assert.assertEquals((long)expectedFlowActivityDoc.getDayTimestamp(), (long)actualFlowActivityDoc.getDayTimestamp());
        Assert.assertEquals((long)expectedFlowActivityDoc.getFlowActivities().size(), (long)actualFlowActivityDoc.getFlowActivities().size());
        Assert.assertEquals((Object)expectedFlowActivityDoc.getFlowName(), (Object)actualFlowActivityDoc.getFlowName());
        Assert.assertEquals((Object)expectedFlowActivityDoc.getType(), (Object)actualFlowActivityDoc.getType());
        Assert.assertEquals((Object)expectedFlowActivityDoc.getUser(), (Object)actualFlowActivityDoc.getUser());
        Assert.assertEquals((Object)expectedFlowActivityDoc.getId(), (Object)actualFlowActivityDoc.getId());
        expectedFlowActivityDoc.addFlowActivity(FLOW_NAME, FLOW_VERSION, System.currentTimeMillis());
        actualFlowActivityDoc.merge(expectedFlowActivityDoc);
        Assert.assertEquals((long)expectedFlowActivityDoc.getDayTimestamp(), (long)actualFlowActivityDoc.getDayTimestamp());
        Assert.assertEquals((long)expectedFlowActivityDoc.getFlowActivities().size(), (long)actualFlowActivityDoc.getFlowActivities().size());
        Assert.assertEquals((Object)expectedFlowActivityDoc.getFlowName(), (Object)actualFlowActivityDoc.getFlowName());
        Assert.assertEquals((Object)expectedFlowActivityDoc.getType(), (Object)actualFlowActivityDoc.getType());
        Assert.assertEquals((Object)expectedFlowActivityDoc.getUser(), (Object)actualFlowActivityDoc.getUser());
        Assert.assertEquals((Object)expectedFlowActivityDoc.getId(), (Object)actualFlowActivityDoc.getId());
    }

    @Test
    public void testFlowRunDocMergeAndAggOperation() throws IOException {
        FlowRunDocument actualFlowRunDoc = new FlowRunDocument();
        FlowRunDocument expectedFlowRunDoc = DocumentStoreTestUtils.bakeFlowRunDoc();
        long timestamp = System.currentTimeMillis();
        long value = 0x5E05000L;
        TimelineMetric timelineMetric = new TimelineMetric();
        timelineMetric.setId(MEMORY_ID);
        timelineMetric.setType(TimelineMetric.Type.SINGLE_VALUE);
        timelineMetric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
        timelineMetric.addValue(timestamp, (Number)0x5E05000L);
        TimelineMetricSubDoc metricSubDoc = new TimelineMetricSubDoc(timelineMetric);
        expectedFlowRunDoc.getMetrics().put(MEMORY_ID, metricSubDoc);
        Assert.assertNull((Object)actualFlowRunDoc.getClusterId());
        Assert.assertNull((Object)actualFlowRunDoc.getFlowName());
        Assert.assertNull((Object)actualFlowRunDoc.getFlowRunId());
        Assert.assertNull((Object)actualFlowRunDoc.getFlowVersion());
        Assert.assertNull((Object)actualFlowRunDoc.getId());
        Assert.assertNull((Object)actualFlowRunDoc.getUsername());
        Assert.assertEquals((Object)actualFlowRunDoc.getType(), (Object)TimelineEntityType.YARN_FLOW_RUN.toString());
        Assert.assertEquals((long)0L, (long)actualFlowRunDoc.getMinStartTime());
        Assert.assertEquals((long)0L, (long)actualFlowRunDoc.getMaxEndTime());
        Assert.assertEquals((long)0L, (long)actualFlowRunDoc.getMetrics().size());
        actualFlowRunDoc.merge(expectedFlowRunDoc);
        Assert.assertEquals((Object)expectedFlowRunDoc.getClusterId(), (Object)actualFlowRunDoc.getClusterId());
        Assert.assertEquals((Object)expectedFlowRunDoc.getFlowName(), (Object)actualFlowRunDoc.getFlowName());
        Assert.assertEquals((Object)expectedFlowRunDoc.getFlowRunId(), (Object)actualFlowRunDoc.getFlowRunId());
        Assert.assertEquals((Object)expectedFlowRunDoc.getFlowVersion(), (Object)actualFlowRunDoc.getFlowVersion());
        Assert.assertEquals((Object)expectedFlowRunDoc.getId(), (Object)actualFlowRunDoc.getId());
        Assert.assertEquals((Object)expectedFlowRunDoc.getUsername(), (Object)actualFlowRunDoc.getUsername());
        Assert.assertEquals((Object)expectedFlowRunDoc.getType(), (Object)actualFlowRunDoc.getType());
        Assert.assertEquals((long)expectedFlowRunDoc.getMinStartTime(), (long)actualFlowRunDoc.getMinStartTime());
        Assert.assertEquals((long)expectedFlowRunDoc.getMaxEndTime(), (long)actualFlowRunDoc.getMaxEndTime());
        Assert.assertEquals((long)expectedFlowRunDoc.getMetrics().size(), (long)actualFlowRunDoc.getMetrics().size());
        actualFlowRunDoc.merge(expectedFlowRunDoc);
        Assert.assertEquals((Object)197173248L, (Object)((TimelineMetricSubDoc)actualFlowRunDoc.getMetrics().get(MEMORY_ID)).getSingleDataValue());
    }
}

