/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.EntityCacheItem;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStore;
import org.apache.hadoop.yarn.server.timeline.EntityGroupPlugInForTest;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.LogInfo;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.PluginStoreTestUtils;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineEntityGroupPlugin;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.Mockito;

public class TestEntityGroupFSTimelineStore
extends TimelineStoreTestUtils {
    private static final String SAMPLE_APP_PREFIX_CACHE_TEST = "1234_000";
    private static final int CACHE_TEST_CACHE_SIZE = 5;
    private static final String TEST_SUMMARY_LOG_FILE_NAME = "summarylog-test";
    private static final String TEST_DOMAIN_LOG_FILE_NAME = "domainlog-test";
    private static final Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestEntityGroupFSTimelineStore.class.getSimpleName());
    private static Configuration config = new YarnConfiguration();
    private static MiniDFSCluster hdfsCluster;
    private static FileSystem fs;
    private static FileContext fc;
    private static FileContextTestHelper fileContextTestHelper;
    private static List<ApplicationId> sampleAppIds;
    private static ApplicationId mainTestAppId;
    private static Path mainTestAppDirPath;
    private static Path testDoneDirPath;
    private static Path testActiveDirPath;
    private static String mainEntityLogFileName;
    private EntityGroupFSTimelineStore store;
    private TimelineEntity entityNew;
    private File rootDir;
    private File testJar;

    @BeforeAll
    public static void setupClass() throws Exception {
        config.setBoolean("yarn.timeline-service.ttl-enable", false);
        config.set("yarn.timeline-service.entity-group-fs-store.summary-entity-types", "YARN_APPLICATION,YARN_APPLICATION_ATTEMPT,YARN_CONTAINER");
        config.setInt("yarn.timeline-service.entity-group-fs-store.app-cache-size", 5);
        config.set("hdfs.minidfs.basedir", TEST_ROOT_DIR.toString());
        HdfsConfiguration hdfsConfig = new HdfsConfiguration();
        hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
        fs = hdfsCluster.getFileSystem();
        fc = FileContext.getFileContext((URI)hdfsCluster.getURI(0), (Configuration)config);
        sampleAppIds = new ArrayList<ApplicationId>(6);
        for (int i = 0; i < 6; ++i) {
            ApplicationId appId = ApplicationId.fromString((String)("application_1234_000" + i));
            sampleAppIds.add(appId);
        }
        testActiveDirPath = TestEntityGroupFSTimelineStore.getTestRootPath("active");
        mainTestAppId = sampleAppIds.get(0);
        mainTestAppDirPath = new Path(testActiveDirPath, mainTestAppId.toString());
        mainEntityLogFileName = "entitylog-" + EntityGroupPlugInForTest.getStandardTimelineGroupId(mainTestAppId);
        testDoneDirPath = TestEntityGroupFSTimelineStore.getTestRootPath("done");
        config.set("yarn.timeline-service.entity-group-fs-store.done-dir", testDoneDirPath.toString());
        config.set("yarn.timeline-service.entity-group-fs-store.active-dir", testActiveDirPath.toString());
    }

    @BeforeEach
    public void setup(TestInfo testInfo) throws Exception {
        for (ApplicationId appId : sampleAppIds) {
            Path attemotDirPath = new Path(new Path(testActiveDirPath, appId.toString()), TestEntityGroupFSTimelineStore.getAttemptDirName(appId));
            this.createTestFiles(appId, attemotDirPath);
        }
        this.store = new EntityGroupFSTimelineStore();
        if (((Method)testInfo.getTestMethod().get()).getName().contains("Plugin")) {
            this.rootDir = GenericTestUtils.getTestDir((String)((Object)((Object)this)).getClass().getSimpleName());
            if (!this.rootDir.exists()) {
                this.rootDir.mkdirs();
            }
            this.testJar = null;
            this.testJar = JarFinder.makeClassLoaderTestJar(((Object)((Object)this)).getClass(), (File)this.rootDir, (String)"test-runjar.jar", (int)2048, (String[])new String[]{EntityGroupPlugInForTest.class.getName()});
            config.set("yarn.timeline-service.entity-group-fs-store.group-id-plugin-classpath", this.testJar.getAbsolutePath());
            String systemClasses = "-org.apache.hadoop.," + ApplicationClassLoader.SYSTEM_CLASSES_DEFAULT;
            config.set("yarn.timeline-service.entity-group-fs-store.group-id-plugin-system-classes", systemClasses);
            config.set("yarn.timeline-service.entity-group-fs-store.group-id-plugin-classes", EntityGroupPlugInForTest.class.getName());
        }
        this.store.init(config);
        this.store.setFs(fs);
        this.store.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.store.stop();
        for (ApplicationId appId : sampleAppIds) {
            fs.delete(new Path(testActiveDirPath, appId.toString()), true);
        }
        if (this.testJar != null) {
            this.testJar.delete();
            this.rootDir.delete();
        }
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        hdfsCluster.shutdown();
        FileContext fileContext = FileContext.getLocalFSFileContext();
        fileContext.delete(new Path(config.get("yarn.timeline-service.leveldb-timeline-store.path")), true);
    }

    @Test
    void testAppLogsScanLogs() throws Exception {
        String fileName;
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        Objects.requireNonNull(entityGroupFSTimelineStore);
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        appLogs.scanForLogs();
        List summaryLogs = appLogs.getSummaryLogs();
        List detailLogs = appLogs.getDetailLogs();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)summaryLogs.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)detailLogs.size());
        for (LogInfo log : summaryLogs) {
            fileName = log.getFilename();
            org.junit.jupiter.api.Assertions.assertTrue((fileName.equals(TEST_SUMMARY_LOG_FILE_NAME) || fileName.equals(TEST_DOMAIN_LOG_FILE_NAME) ? 1 : 0) != 0);
        }
        for (LogInfo log : detailLogs) {
            fileName = log.getFilename();
            org.junit.jupiter.api.Assertions.assertEquals((Object)fileName, (Object)mainEntityLogFileName);
        }
    }

    @Test
    void testAppLogsDomainLogLastlyScanned() throws Exception {
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        Objects.requireNonNull(entityGroupFSTimelineStore);
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        Path attemptDirPath = new Path(new Path(testActiveDirPath, mainTestAppId.toString()), TestEntityGroupFSTimelineStore.getAttemptDirName(mainTestAppId));
        fs.delete(new Path(attemptDirPath, TEST_DOMAIN_LOG_FILE_NAME), false);
        appLogs.scanForLogs();
        List summaryLogs = appLogs.getSummaryLogs();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)summaryLogs.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_SUMMARY_LOG_FILE_NAME, (Object)((LogInfo)summaryLogs.get(0)).getFilename());
        FSDataOutputStream out = fs.create(new Path(attemptDirPath, TEST_DOMAIN_LOG_FILE_NAME));
        out.close();
        appLogs.scanForLogs();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)summaryLogs.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DOMAIN_LOG_FILE_NAME, (Object)((LogInfo)summaryLogs.get(0)).getFilename());
    }

    @Test
    void testMoveToDone() throws Exception {
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        Objects.requireNonNull(entityGroupFSTimelineStore);
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        Path pathBefore = appLogs.getAppDirPath();
        appLogs.moveToDone();
        Path pathAfter = appLogs.getAppDirPath();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)pathBefore, (Object)pathAfter);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pathAfter.toString().contains(testDoneDirPath.toString()));
        fs.delete(pathAfter, true);
    }

    @Test
    void testParseSummaryLogs() throws Exception {
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithMemStore(config);
        MutableCounterLong scanned = this.store.metrics.getEntitiesReadToSummary();
        long beforeScan = scanned.value();
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        Objects.requireNonNull(entityGroupFSTimelineStore);
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        appLogs.scanForLogs();
        appLogs.parseSummaryLogs(tdm);
        PluginStoreTestUtils.verifyTestEntities(tdm);
        org.junit.jupiter.api.Assertions.assertEquals((long)(beforeScan + 2L), (long)scanned.value());
    }

    @Test
    void testWithAnonymousUser() throws Exception {
        try {
            TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithMemStore(config);
            EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
            Objects.requireNonNull(entityGroupFSTimelineStore);
            EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
            FileStatus fileStatus = (FileStatus)Mockito.mock(FileStatus.class);
            Mockito.when((Object)fileStatus.getOwner()).thenReturn(null);
            appLogs.scanForLogs();
            appLogs.parseSummaryLogs(tdm);
            PluginStoreTestUtils.verifyTestEntities(tdm);
        }
        catch (IllegalArgumentException ie) {
            org.junit.jupiter.api.Assertions.fail((String)"No exception needs to be thrown as anonymous user is configured");
        }
    }

    @Test
    void testCleanLogs() throws Exception {
        String appDirName = mainTestAppId.toString();
        String attemptDirName = "appattempt" + appDirName + "_1";
        Path irrelevantFilePath = new Path(testDoneDirPath, "irrelevant.log");
        FSDataOutputStream stream = fs.create(irrelevantFilePath);
        stream.close();
        Path irrelevantDirPath = new Path(testDoneDirPath, "irrelevant");
        fs.mkdirs(irrelevantDirPath);
        Path doneAppHomeDir = new Path(new Path(new Path(testDoneDirPath, Long.toString(mainTestAppId.getClusterTimestamp())), "0000"), "001");
        Path appDirClean = new Path(doneAppHomeDir, appDirName);
        Path attemptDirClean = new Path(appDirClean, attemptDirName);
        fs.mkdirs(attemptDirClean);
        Path filePath = new Path(attemptDirClean, "test.log");
        stream = fs.create(filePath);
        stream.close();
        Path appDirHoldByFile = new Path(doneAppHomeDir, appDirName + "1");
        Path attemptDirHoldByFile = new Path(appDirHoldByFile, attemptDirName);
        fs.mkdirs(attemptDirHoldByFile);
        Path filePathHold = new Path(attemptDirHoldByFile, "test1.log");
        stream = fs.create(filePathHold);
        stream.close();
        Path appDirHoldByDir = new Path(doneAppHomeDir, appDirName + "2");
        Path attemptDirHoldByDir = new Path(appDirHoldByDir, attemptDirName);
        fs.mkdirs(attemptDirHoldByDir);
        Path dirPathHold = new Path(attemptDirHoldByDir, "hold");
        fs.mkdirs(dirPathHold);
        Path appDirEmpty = new Path(doneAppHomeDir, appDirName + "3");
        Path attemptDirEmpty = new Path(appDirEmpty, attemptDirName);
        fs.mkdirs(attemptDirEmpty);
        Path dirPathEmpty = new Path(attemptDirEmpty, "empty");
        fs.mkdirs(dirPathEmpty);
        MutableCounterLong dirsCleaned = this.store.metrics.getLogsDirsCleaned();
        long before = dirsCleaned.value();
        this.store.cleanLogs(testDoneDirPath, 10000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(irrelevantDirPath));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(irrelevantFilePath));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(filePath));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(filePathHold));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(dirPathHold));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(dirPathEmpty));
        Thread.sleep(2000L);
        stream = fs.append(filePathHold);
        stream.writeBytes("append");
        stream.close();
        fs.mkdirs(new Path(dirPathHold, "holdByMe"));
        this.store.cleanLogs(testDoneDirPath, 1000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(irrelevantDirPath));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(irrelevantFilePath));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(filePathHold));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(dirPathHold));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(doneAppHomeDir));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(appDirClean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(appDirEmpty));
        org.junit.jupiter.api.Assertions.assertEquals((long)(before + 2L), (long)dirsCleaned.value());
    }

    @Test
    void testCleanBuckets() throws Exception {
        Path clusterTimeStampDir1 = new Path(testDoneDirPath, Long.toString(sampleAppIds.get(0).getClusterTimestamp()));
        Path appDir1 = new Path(new Path(new Path(clusterTimeStampDir1, "0000"), "000"), sampleAppIds.get(0).toString());
        Path appDir2 = new Path(new Path(new Path(clusterTimeStampDir1, "0000"), "001"), sampleAppIds.get(1).toString());
        Path appDir3 = new Path(new Path(new Path(clusterTimeStampDir1, "0000"), "002"), sampleAppIds.get(2).toString());
        Path appDir4 = new Path(new Path(new Path(clusterTimeStampDir1, "0001"), "000"), sampleAppIds.get(3).toString());
        Path clusterTimeStampDir2 = new Path(testDoneDirPath, "1235");
        Path clusterTimeStampDir3 = new Path(testDoneDirPath, "irrevelant");
        Path appDir5 = new Path(new Path(new Path(clusterTimeStampDir3, "0000"), "000"), sampleAppIds.get(4).toString());
        fs.mkdirs(appDir1);
        fs.mkdirs(appDir2);
        fs.mkdirs(appDir3);
        fs.mkdirs(appDir4);
        fs.mkdirs(clusterTimeStampDir2);
        fs.mkdirs(appDir5);
        Thread.sleep(2000L);
        this.store.cleanLogs(testDoneDirPath, 1000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(clusterTimeStampDir1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(appDir1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(appDir2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(appDir3));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(appDir4));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(clusterTimeStampDir2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(appDir5));
        this.store.cleanLogs(testDoneDirPath, 1000L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fs.exists(clusterTimeStampDir1));
    }

    @Test
    void testNullCheckGetEntityTimelines() throws Exception {
        try {
            this.store.getEntityTimelines("YARN_APPLICATION", null, null, null, null, null);
        }
        catch (NullPointerException e) {
            org.junit.jupiter.api.Assertions.fail((String)"NPE when getEntityTimelines called with Null EntityIds");
        }
    }

    @Test
    void testPluginRead() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((Object)EntityGroupPlugInForTest.class.getName(), (Object)this.store.getConfig().get("yarn.timeline-service.entity-group-fs-store.group-id-plugin-classes"));
        List currPlugins = this.store.getPlugins();
        for (TimelineEntityGroupPlugin plugin : currPlugins) {
            ClassLoader pluginClassLoader = plugin.getClass().getClassLoader();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(pluginClassLoader instanceof ApplicationClassLoader), (String)"Should set up ApplicationClassLoader");
            URL[] paths = ((URLClassLoader)pluginClassLoader).getURLs();
            boolean foundJAR = false;
            for (URL path : paths) {
                if (!path.toString().contains(this.testJar.getAbsolutePath())) continue;
                foundJAR = true;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)foundJAR, (String)("Not found path " + this.testJar.getAbsolutePath() + " for plugin " + plugin.getClass().getName()));
        }
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        Objects.requireNonNull(entityGroupFSTimelineStore);
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        EntityCacheItem cacheItem = new EntityCacheItem(EntityGroupPlugInForTest.getStandardTimelineGroupId(mainTestAppId), config);
        cacheItem.setAppLogs(appLogs);
        this.store.setCachedLogs(EntityGroupPlugInForTest.getStandardTimelineGroupId(mainTestAppId), cacheItem);
        MutableCounterLong detailLogEntityRead = this.store.metrics.getGetEntityToDetailOps();
        MutableStat cacheRefresh = this.store.metrics.getCacheRefresh();
        long numEntityReadBefore = detailLogEntityRead.value();
        long cacheRefreshBefore = cacheRefresh.lastStat().numSamples();
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithStore(config, (TimelineStore)this.store);
        TimelineEntity entity3 = tdm.getEntity("type_3", mainTestAppId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity3);
        org.junit.jupiter.api.Assertions.assertEquals((Long)this.entityNew.getStartTime(), (Long)entity3.getStartTime());
        NameValuePair primaryFilter = new NameValuePair("appid", (Object)mainTestAppId.toString());
        TimelineEntities entities = tdm.getEntities("type_3", primaryFilter, null, null, null, null, null, null, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)entities.getEntities().size());
        for (TimelineEntity entity : entities.getEntities()) {
            org.junit.jupiter.api.Assertions.assertEquals((Long)this.entityNew.getStartTime(), (Long)entity.getStartTime());
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)(numEntityReadBefore + 2L), (long)detailLogEntityRead.value());
        org.junit.jupiter.api.Assertions.assertEquals((long)(cacheRefreshBefore + 1L), (long)cacheRefresh.lastStat().numSamples());
    }

    @Test
    void testSummaryRead() throws Exception {
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        Objects.requireNonNull(entityGroupFSTimelineStore);
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        MutableCounterLong summaryLogEntityRead = this.store.metrics.getGetEntityToSummaryOps();
        long numEntityReadBefore = summaryLogEntityRead.value();
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithStore(config, (TimelineStore)this.store);
        appLogs.scanForLogs();
        appLogs.parseSummaryLogs(tdm);
        PluginStoreTestUtils.verifyTestEntities(tdm);
        TimelineEntities entities = tdm.getEntities("type_1", null, null, null, null, null, null, null, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        Assertions.assertThat((List)entities.getEntities()).hasSize(1);
        for (TimelineEntity entity : entities.getEntities()) {
            org.junit.jupiter.api.Assertions.assertEquals((Long)123L, (Long)entity.getStartTime());
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)(numEntityReadBefore + 5L), (long)summaryLogEntityRead.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntityPluginRead() throws Exception {
        EntityGroupFSTimelineStore store = null;
        ApplicationId appId = ApplicationId.fromString((String)"application_1501509265053_0001");
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path userBase = new Path(testActiveDirPath, user);
        Path userAppRoot = new Path(userBase, appId.toString());
        Path attemotDirPath = new Path(userAppRoot, TestEntityGroupFSTimelineStore.getAttemptDirName(appId));
        try {
            store = this.createAndStartTimelineStore(EntityGroupFSTimelineStore.AppState.ACTIVE);
            String logFileName = "entitylog-" + EntityGroupPlugInForTest.getStandardTimelineGroupId(appId);
            this.createTestFiles(appId, attemotDirPath, logFileName);
            TimelineEntity entity = store.getEntity(this.entityNew.getEntityId(), this.entityNew.getEntityType(), EnumSet.allOf(TimelineReader.Field.class));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.entityNew.getEntityId(), (Object)entity.getEntityId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.entityNew.getEntityType(), (Object)entity.getEntityType());
        }
        finally {
            if (store != null) {
                store.stop();
            }
            fs.delete(userBase, true);
        }
    }

    @Test
    void testScanActiveLogsWithInvalidFile() throws Exception {
        Path invalidFile = new Path(testActiveDirPath, "invalidfile");
        try {
            if (!fs.exists(invalidFile)) {
                fs.createNewFile(invalidFile);
            }
            this.store.scanActiveLogs();
        }
        catch (StackOverflowError error) {
            org.junit.jupiter.api.Assertions.fail((String)"EntityLogScanner crashed with StackOverflowError");
        }
        finally {
            if (fs.exists(invalidFile)) {
                fs.delete(invalidFile, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testScanActiveLogsAndMoveToDonePluginRead() throws Exception {
        EntityGroupFSTimelineStore store = null;
        ApplicationId appId = ApplicationId.fromString((String)"application_1501509265053_0002");
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path userBase = new Path(testActiveDirPath, user);
        Path userAppRoot = new Path(userBase, appId.toString());
        Path attemotDirPath = new Path(userAppRoot, TestEntityGroupFSTimelineStore.getAttemptDirName(appId));
        try {
            store = this.createAndStartTimelineStore(EntityGroupFSTimelineStore.AppState.COMPLETED);
            String logFileName = "entitylog-" + EntityGroupPlugInForTest.getStandardTimelineGroupId(appId);
            this.createTestFiles(appId, attemotDirPath, logFileName);
            store.scanActiveLogs();
            TimelineEntity entity = store.getEntity(this.entityNew.getEntityId(), this.entityNew.getEntityType(), EnumSet.allOf(TimelineReader.Field.class));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.entityNew.getEntityId(), (Object)entity.getEntityId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.entityNew.getEntityType(), (Object)entity.getEntityType());
        }
        finally {
            if (store != null) {
                store.stop();
            }
            fs.delete(userBase, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testIfAnyDuplicateEntities() throws Exception {
        ApplicationId appId = ApplicationId.fromString((String)"application_1501509265053_0002");
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path activeDirPath = TestEntityGroupFSTimelineStore.getTestRootPath("active1");
        Path doneDirPath = TestEntityGroupFSTimelineStore.getTestRootPath("done1");
        Path userBase = new Path(activeDirPath, user);
        Path userAppRoot = new Path(userBase, appId.toString());
        Path attemptDirPath = new Path(userAppRoot, TestEntityGroupFSTimelineStore.getAttemptDirName(appId));
        String logFileName = "entitylog-" + EntityGroupPlugInForTest.getStandardTimelineGroupId(appId);
        this.createTestFiles(appId, attemptDirPath, logFileName);
        this.store.stop();
        EntityGroupFSTimelineStore newStore = new EntityGroupFSTimelineStore(){

            protected EntityGroupFSTimelineStore.AppState getAppState(ApplicationId appId) throws IOException {
                return EntityGroupFSTimelineStore.AppState.ACTIVE;
            }
        };
        try {
            YarnConfiguration newConfig = new YarnConfiguration(config);
            newConfig.set("yarn.timeline-service.entity-group-fs-store.summary-store", TestTimelineStore.class.getName());
            newConfig.set("yarn.timeline-service.entity-group-fs-store.done-dir", doneDirPath.toString());
            newConfig.set("yarn.timeline-service.entity-group-fs-store.active-dir", activeDirPath.toString());
            newStore.init((Configuration)newConfig);
            newStore.setFs(fs);
            newStore.start();
            newStore.scanActiveLogs();
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return TestTimelineStore.getEntitiesCount() == 2;
                }
            }, (long)100L, (long)10000L);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)TestTimelineStore.getEntitiesCount(), (String)"Wrong Initial Entities Count");
            TimelineEntities entities = PluginStoreTestUtils.generateTestEntities();
            FSDataOutputStream outStream = fs.append(new Path(attemptDirPath, TEST_SUMMARY_LOG_FILE_NAME));
            JsonGenerator jsonGenerator = new JsonFactory().createGenerator((OutputStream)outStream);
            jsonGenerator.setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter("\n"));
            ObjectMapper objMapper = new ObjectMapper();
            objMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()));
            objMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            for (TimelineEntity entity : entities.getEntities()) {
                objMapper.writeValue(jsonGenerator, (Object)entity);
            }
            outStream.close();
            newStore.scanActiveLogs();
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return TestTimelineStore.getEntitiesCount() == 4;
                }
            }, (long)100L, (long)10000L);
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)TestTimelineStore.getEntitiesCount(), (String)"Duplicate Entities present");
        }
        finally {
            if (newStore != null) {
                newStore.stop();
            }
            fs.delete(userAppRoot, true);
        }
    }

    @Test
    void testStateStoreAndRecovery() throws Exception {
        EntityGroupFSTimelineStore entityGroupFSTimelineStore = this.store;
        Objects.requireNonNull(entityGroupFSTimelineStore);
        EntityGroupFSTimelineStore.AppLogs appLogs = new EntityGroupFSTimelineStore.AppLogs(entityGroupFSTimelineStore, mainTestAppId, mainTestAppDirPath, EntityGroupFSTimelineStore.AppState.COMPLETED);
        appLogs.scanForLogs();
        List summaryLogs = appLogs.getSummaryLogs();
        ArrayList<EntityGroupFSTimelineStore.AppLogs> logsList = new ArrayList<EntityGroupFSTimelineStore.AppLogs>();
        logsList.add(appLogs);
        Path checkpointFile = new Path(fs.getHomeDirectory(), "atscheckpoint");
        try (FSDataOutputStream dataOutputStream = fs.create(checkpointFile);){
            this.store.storeLogFiles(logsList, (DataOutputStream)dataOutputStream);
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Failed to store the log files");
        }
        try (FSDataInputStream dataInputStream = fs.open(checkpointFile);){
            HashMap logFiles = this.store.recoverLogFiles((DataInputStream)dataInputStream);
            org.junit.jupiter.api.Assertions.assertEquals((int)summaryLogs.size(), (int)logFiles.size());
            for (LogInfo logInfo : summaryLogs) {
                String logFileName = logInfo.getAttemptDirName() + "/" + logInfo.getFilename();
                Pair pair = (Pair)logFiles.get(logFileName);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)pair, (String)("Failed to recover " + logFileName));
                org.junit.jupiter.api.Assertions.assertTrue((logInfo.getLastProcessedTime() == ((Long)pair.getLeft()).longValue() ? 1 : 0) != 0, (String)"LastProcessedTime is not same");
                org.junit.jupiter.api.Assertions.assertTrue((logInfo.getOffset() == ((Long)pair.getRight()).longValue() ? 1 : 0) != 0, (String)"Offset is not same");
            }
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Failed to recover the log files");
        }
    }

    private EntityGroupFSTimelineStore createAndStartTimelineStore(final EntityGroupFSTimelineStore.AppState appstate) {
        this.store.stop();
        EntityGroupFSTimelineStore newStore = new EntityGroupFSTimelineStore(){

            protected EntityGroupFSTimelineStore.AppState getAppState(ApplicationId appId) throws IOException {
                return appstate;
            }
        };
        newStore.init(config);
        newStore.setFs(fs);
        newStore.start();
        return newStore;
    }

    private void createTestFiles(ApplicationId appId, Path attemptDirPath) throws IOException {
        this.createTestFiles(appId, attemptDirPath, mainEntityLogFileName);
    }

    private void createTestFiles(ApplicationId appId, Path attemptDirPath, String logPath) throws IOException {
        TimelineEntities entities = PluginStoreTestUtils.generateTestEntities();
        PluginStoreTestUtils.writeEntities(entities, new Path(attemptDirPath, TEST_SUMMARY_LOG_FILE_NAME), fs);
        HashMap<String, Set<Object>> primaryFilters = new HashMap<String, Set<Object>>();
        HashSet<String> appSet = new HashSet<String>();
        appSet.add(appId.toString());
        primaryFilters.put("appid", appSet);
        this.entityNew = PluginStoreTestUtils.createEntity(appId.toString(), "type_3", 789L, null, null, primaryFilters, null, "domain_id_1");
        TimelineEntities entityList = new TimelineEntities();
        entityList.addEntity(this.entityNew);
        PluginStoreTestUtils.writeEntities(entityList, new Path(attemptDirPath, logPath), fs);
        FSDataOutputStream out = fs.create(new Path(attemptDirPath, TEST_DOMAIN_LOG_FILE_NAME));
        out.close();
    }

    private static Path getTestRootPath(String pathString) {
        return fileContextTestHelper.getTestRootPath(fc, pathString);
    }

    private static String getAttemptDirName(ApplicationId appId) {
        return "appattempt" + appId.toString() + "_1";
    }

    static {
        fileContextTestHelper = new FileContextTestHelper("/tmp/TestEntityGroupFSTimelineStore");
    }

    static class TestTimelineStore
    extends LeveldbTimelineStore {
        static final AtomicInteger ENTITIES_COUNT = new AtomicInteger(0);

        TestTimelineStore() {
        }

        public TimelinePutResponse put(TimelineEntities entities) {
            ENTITIES_COUNT.getAndAdd(entities.getEntities().size());
            return new TimelinePutResponse();
        }

        public static int getEntitiesCount() {
            return ENTITIES_COUNT.get();
        }
    }
}

